/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointModifier;
import io.quarkus.arc.processor.InvocationTransformer;
import io.quarkus.arc.processor.InvocationTransformerKind;
import io.quarkus.arc.processor.InvokerInfo;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;

public class InvokerBuilder {
    final BeanInfo targetBean;
    final ClassInfo targetBeanClass;
    final MethodInfo targetMethod;
    boolean instanceLookup;
    boolean[] argumentLookups;
    InvocationTransformer instanceTransformer;
    InvocationTransformer[] argumentTransformers;
    InvocationTransformer returnValueTransformer;
    InvocationTransformer exceptionTransformer;
    InvocationTransformer invocationWrapper;
    private final BeanDeployment beanDeployment;
    private final InjectionPointModifier injectionPointTransformer;

    InvokerBuilder(BeanInfo targetBean, MethodInfo targetMethod, BeanDeployment beanDeployment, InjectionPointModifier injectionPointTransformer) {
        this.targetBean = targetBean;
        this.targetBeanClass = targetBean.getImplClazz();
        this.targetMethod = targetMethod;
        this.argumentTransformers = new InvocationTransformer[targetMethod.parametersCount()];
        this.argumentLookups = new boolean[targetMethod.parametersCount()];
        this.beanDeployment = beanDeployment;
        this.injectionPointTransformer = injectionPointTransformer;
    }

    public InvokerBuilder withInstanceLookup() {
        this.instanceLookup = true;
        return this;
    }

    public InvokerBuilder withArgumentLookup(int position) {
        if (position < 0 || position >= this.argumentLookups.length) {
            throw new IllegalArgumentException("Position must be >= 0 && < " + this.argumentLookups.length);
        }
        this.argumentLookups[position] = true;
        return this;
    }

    public InvokerBuilder withInstanceTransformer(Class<?> clazz, String methodName) {
        if (this.instanceTransformer != null) {
            throw new IllegalStateException("Instance transformer already set");
        }
        this.instanceTransformer = new InvocationTransformer(InvocationTransformerKind.INSTANCE, clazz, methodName);
        return this;
    }

    public InvokerBuilder withArgumentTransformer(int position, Class<?> clazz, String methodName) {
        if (position < 0 || position >= this.argumentTransformers.length) {
            throw new IllegalArgumentException("Position must be >= 0 && < " + this.argumentTransformers.length);
        }
        if (this.argumentTransformers[position] != null) {
            throw new IllegalStateException("Argument transformer already set for position " + position);
        }
        this.argumentTransformers[position] = new InvocationTransformer(InvocationTransformerKind.ARGUMENT, clazz, methodName);
        return this;
    }

    public InvokerBuilder withReturnValueTransformer(Class<?> clazz, String methodName) {
        if (this.returnValueTransformer != null) {
            throw new IllegalStateException("Return value transformer already set");
        }
        this.returnValueTransformer = new InvocationTransformer(InvocationTransformerKind.RETURN_VALUE, clazz, methodName);
        return this;
    }

    public InvokerBuilder withExceptionTransformer(Class<?> clazz, String methodName) {
        if (this.exceptionTransformer != null) {
            throw new IllegalStateException("Exception transformer already set");
        }
        this.exceptionTransformer = new InvocationTransformer(InvocationTransformerKind.EXCEPTION, clazz, methodName);
        return this;
    }

    public InvokerBuilder withInvocationWrapper(Class<?> clazz, String methodName) {
        if (this.invocationWrapper != null) {
            throw new IllegalStateException("Invocation wrapper already set");
        }
        this.invocationWrapper = new InvocationTransformer(InvocationTransformerKind.WRAPPER, clazz, methodName);
        return this;
    }

    public InvokerInfo build() {
        Injection argumentsInjection = Injection.forInvokerArgumentLookups(this.targetBean.getImplClazz(), this.targetMethod, this.argumentLookups, this.beanDeployment, this.injectionPointTransformer);
        InvokerInfo result = new InvokerInfo(this, argumentsInjection, this.beanDeployment);
        this.beanDeployment.addInvoker(result);
        return result;
    }
}

