/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.commons.util.Util;
import org.infinispan.multimap.impl.BaseSetBucket;
import org.infinispan.multimap.impl.ScoredValue;
import org.infinispan.multimap.impl.SortableBucket;
import org.infinispan.multimap.impl.internal.MultimapObjectWrapper;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5305)
public class SetBucket<V>
implements SortableBucket<V>,
BaseSetBucket<V> {
    final Set<MultimapObjectWrapper<V>> values;

    public SetBucket() {
        this.values = new HashSet<MultimapObjectWrapper<V>>();
    }

    public SetBucket(V value) {
        HashSet<MultimapObjectWrapper<V>> set = new HashSet<MultimapObjectWrapper<V>>(1);
        set.add(new MultimapObjectWrapper<V>(value));
        this.values = set;
    }

    private SetBucket(Set<MultimapObjectWrapper<V>> values) {
        this.values = values;
    }

    public static <V> SetBucket<V> create(Collection<V> values) {
        return new SetBucket<V>(values.stream().map(MultimapObjectWrapper::new).collect(Collectors.toSet()));
    }

    public static <V> SetBucket<V> create(V value) {
        return new SetBucket<V>(value);
    }

    @ProtoFactory
    SetBucket(Collection<MultimapObjectWrapper<V>> wrappedValues) {
        this.values = new HashSet<MultimapObjectWrapper<V>>(wrappedValues);
    }

    @ProtoField(number=1, collectionImplementation=ArrayList.class)
    Collection<MultimapObjectWrapper<V>> getWrappedValues() {
        return new ArrayList<MultimapObjectWrapper<V>>(this.values);
    }

    public boolean contains(V value) {
        for (MultimapObjectWrapper<V> v : this.values) {
            if (!Objects.deepEquals(v.get(), value)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Set<ScoredValue<V>> getAsSet() {
        return this.values.stream().map(v -> new ScoredValue(1.0, v)).collect(Collectors.toSet());
    }

    @Override
    public List<ScoredValue<V>> getAsList() {
        return this.values.stream().map(v -> new ScoredValue(1.0, v)).toList();
    }

    @Override
    public Double getScore(MultimapObjectWrapper<V> key) {
        return 1.0;
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public int size() {
        return this.values.size();
    }

    public Set<V> toSet() {
        return this.values.stream().map(MultimapObjectWrapper::get).collect(Collectors.toSet());
    }

    public List<V> toList() {
        return this.values.stream().map(mow -> mow.get()).collect(Collectors.toList());
    }

    public String toString() {
        return "SetBucket{values=" + Util.toStr(this.values) + "}";
    }

    public SetBucketResult<Boolean, V> addAll(Collection<V> values) {
        HashSet<MultimapObjectWrapper<V>> existing = new HashSet<MultimapObjectWrapper<V>>(this.values);
        boolean added = false;
        for (V value : values) {
            added |= existing.add(new MultimapObjectWrapper<V>(value));
        }
        return new SetBucketResult<Boolean, V>(added, new SetBucket<V>(existing));
    }

    public SetBucketResult<Boolean, V> removeAll(Collection<V> values) {
        Boolean changed = Boolean.FALSE;
        HashSet<MultimapObjectWrapper<V>> existing = new HashSet<MultimapObjectWrapper<V>>(this.values.size());
        for (MultimapObjectWrapper<V> value : this.values) {
            if (this.contains(values, value)) {
                changed = Boolean.TRUE;
                continue;
            }
            existing.add(value);
        }
        return new SetBucketResult<Boolean, V>(changed, new SetBucket<V>(existing));
    }

    private boolean contains(Collection<V> collection, MultimapObjectWrapper<V> wrapped) {
        for (V v : collection) {
            if (!wrapped.wrappedEquals(v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Stream<MultimapObjectWrapper<V>> stream() {
        return this.values.stream();
    }

    @Override
    public List<ScoredValue<V>> sort(SortableBucket.SortOptions sortOptions) {
        Stream scoredValueStream = sortOptions.alpha ? this.values.stream().map(v -> new ScoredValue(1.0, v)) : this.values.stream().map(v -> new ScoredValue(v.asDouble(), v));
        return this.sort(scoredValueStream, sortOptions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetBucket setBucket = (SetBucket)o;
        return Objects.equals(this.values, setBucket.values);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public record SetBucketResult<R, E>(R result, SetBucket<E> bucket) {
    }
}

