/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.list;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.ListBucket;
import org.infinispan.multimap.impl.function.list.ListBucketBaseFunction;

public final class SubListFunction<K, V>
implements ListBucketBaseFunction<K, V, Collection<V>> {
    public static final AdvancedExternalizer<SubListFunction> EXTERNALIZER = new Externalizer();
    private final long from;
    private final long to;

    public SubListFunction(long from, long to) {
        this.from = from;
        this.to = to;
    }

    public Collection<V> apply(EntryView.ReadWriteEntryView<K, ListBucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (existing.isPresent()) {
            return ((ListBucket)existing.get()).sublist(this.from, this.to);
        }
        return null;
    }

    private static class Externalizer
    implements AdvancedExternalizer<SubListFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends SubListFunction>> getTypeClasses() {
            return Collections.singleton(SubListFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.SUBLIST_FUNCTION;
        }

        public void writeObject(ObjectOutput output, SubListFunction object) throws IOException {
            output.writeLong(object.from);
            output.writeLong(object.to);
        }

        public SubListFunction readObject(ObjectInput input) throws IOException {
            return new SubListFunction(input.readLong(), input.readLong());
        }
    }
}

