/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import io.quarkus.fs.util.ZipUtils;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Locale;

public class SchemaToolingUtil {
    private static final String SQL_LOAD_SCRIPT_UNZIPPED_DIR_PREFIX = "import-sql-unzip-";

    public static String unzipZipFilesAndReplaceZips(String commaSeparatedFileNames) {
        ArrayList<String> unzippedFilesNames = new ArrayList<String>();
        if (commaSeparatedFileNames != null) {
            String[] fileNames;
            for (String fileName : fileNames = commaSeparatedFileNames.split(",")) {
                if (fileName.endsWith(".zip")) {
                    try {
                        Path unzipDir = Files.createTempDirectory(SQL_LOAD_SCRIPT_UNZIPPED_DIR_PREFIX, new FileAttribute[0]);
                        URL resource = Thread.currentThread().getContextClassLoader().getResource(fileName);
                        Path zipFile = Paths.get(resource.toURI());
                        ZipUtils.unzip((Path)zipFile, (Path)unzipDir);
                        try (DirectoryStream<Path> paths = Files.newDirectoryStream(unzipDir);){
                            for (Path path : paths) {
                                unzippedFilesNames.add(path.toAbsolutePath().toString());
                            }
                            continue;
                        }
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(String.format(Locale.ROOT, "Error unzipping import file %s: %s", fileName, e.getMessage()), e);
                    }
                }
                unzippedFilesNames.add(fileName);
            }
            return String.join((CharSequence)",", unzippedFilesNames);
        }
        return null;
    }
}

