/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.collection.AbstractQueue;
import io.vavr.collection.Collections;
import io.vavr.collection.JavaConverters;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.List;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

public final class Queue<T>
extends AbstractQueue<T, Queue<T>>
implements LinearSeq<T> {
    private static final long serialVersionUID = 1L;
    private static final Queue<?> EMPTY = new Queue(List.empty(), List.empty());
    private final List<T> front;
    private final List<T> rear;

    private Queue(List<T> front, List<T> rear) {
        boolean frontIsEmpty = front.isEmpty();
        this.front = frontIsEmpty ? rear.reverse() : front;
        this.rear = frontIsEmpty ? front : rear;
    }

    public static <T> Queue<T> empty() {
        return EMPTY;
    }

    public static <T> Queue<T> of(T element) {
        return Queue.ofAll(List.of(element));
    }

    public static <T> Queue<T> ofAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (elements instanceof Queue) {
            return (Queue)elements;
        }
        if (elements instanceof JavaConverters.ListView && ((JavaConverters.ListView)elements).getDelegate() instanceof Queue) {
            return (Queue)((JavaConverters.ListView)elements).getDelegate();
        }
        if (!elements.iterator().hasNext()) {
            return Queue.empty();
        }
        if (elements instanceof List) {
            return new Queue((List)elements, List.empty());
        }
        return new Queue<T>(List.ofAll(elements), List.empty());
    }

    public Queue<T> enqueue(T element) {
        return new Queue<T>(this.front, this.rear.prepend(element));
    }

    public Queue<T> enqueueAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (this.isEmpty() && elements instanceof Queue) {
            return (Queue)elements;
        }
        return List.ofAll(elements).foldLeft(this, Queue::enqueue);
    }

    @Override
    public Queue<T> append(T element) {
        return this.enqueue(element);
    }

    @Override
    public Queue<T> appendAll(Iterable<? extends T> elements) {
        return this.enqueueAll(elements);
    }

    public <U> Queue<T> distinctBy(Function<? super T, ? extends U> keyExtractor) {
        Objects.requireNonNull(keyExtractor, "keyExtractor is null");
        return Queue.ofAll(this.toList().distinctBy(keyExtractor));
    }

    @Override
    public Queue<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        LinearSeq filtered = this.toList().filter((Predicate)predicate);
        if (filtered.isEmpty()) {
            return Queue.empty();
        }
        if (filtered.length() == this.length()) {
            return this;
        }
        return Queue.ofAll(filtered);
    }

    @Override
    public T get(int index) {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("get(" + index + ") on empty Queue");
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("get(" + index + ")");
        }
        int length = this.front.length();
        if (index < length) {
            return this.front.get(index);
        }
        int rearIndex = index - length;
        int rearLength = this.rear.length();
        if (rearIndex < rearLength) {
            int reverseRearIndex = rearLength - rearIndex - 1;
            return this.rear.get(reverseRearIndex);
        }
        throw new IndexOutOfBoundsException("get(" + index + ") on Queue of length " + this.length());
    }

    @Override
    public boolean hasDefiniteSize() {
        return true;
    }

    @Override
    public T head() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("head of empty " + this.stringPrefix());
        }
        return this.front.head();
    }

    @Override
    public int indexOf(T element, int from2) {
        int frontIndex = this.front.indexOf(element, from2);
        if (frontIndex != -1) {
            return frontIndex;
        }
        int rearIndex = this.rear.reverse().indexOf(element, from2 - this.front.length());
        return rearIndex == -1 ? -1 : rearIndex + this.front.length();
    }

    public Queue<T> init() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("init of empty " + this.stringPrefix());
        }
        if (this.rear.isEmpty()) {
            return new Queue<T>(this.front.init(), this.rear);
        }
        return new Queue<T>(this.front, this.rear.tail());
    }

    @Override
    public Queue<T> insert(int index, T element) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("insert(" + index + ", element)");
        }
        int length = this.front.length();
        if (index <= length) {
            return new Queue<T>(this.front.insert(index, (Object)element), this.rear);
        }
        int rearIndex = index - length;
        int rearLength = this.rear.length();
        if (rearIndex <= rearLength) {
            int reverseRearIndex = rearLength - rearIndex;
            return new Queue<T>(this.front, this.rear.insert(reverseRearIndex, (Object)element));
        }
        throw new IndexOutOfBoundsException("insert(" + index + ", element) on Queue of length " + this.length());
    }

    @Override
    public Queue<T> insertAll(int index, Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (index < 0) {
            throw new IndexOutOfBoundsException("insertAll(" + index + ", elements)");
        }
        int length = this.front.length();
        if (index <= length) {
            if (this.isEmpty() && elements instanceof Queue) {
                return (Queue)elements;
            }
            LinearSeq newFront = this.front.insertAll(index, (Iterable)elements);
            return newFront == this.front ? this : new Queue<T>(newFront, this.rear);
        }
        int rearIndex = index - length;
        int rearLength = this.rear.length();
        if (rearIndex <= rearLength) {
            int reverseRearIndex = rearLength - rearIndex;
            LinearSeq newRear = this.rear.insertAll(reverseRearIndex, (Iterable)List.ofAll(elements).reverse());
            return newRear == this.rear ? this : new Queue<T>(this.front, newRear);
        }
        throw new IndexOutOfBoundsException("insertAll(" + index + ", elements) on Queue of length " + this.length());
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.front.isEmpty();
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    @Override
    public boolean isTraversableAgain() {
        return true;
    }

    @Override
    public T last() {
        return this.rear.isEmpty() ? this.front.last() : this.rear.head();
    }

    @Override
    public int lastIndexOf(T element, int end) {
        return this.toList().lastIndexOf(element, end);
    }

    @Override
    public int length() {
        return this.front.length() + this.rear.length();
    }

    @Override
    public <U> Queue<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return new Queue<T>(this.front.map(mapper), this.rear.map(mapper));
    }

    @Override
    public Queue<T> remove(T element) {
        LinearSeq removed = this.toList().remove((Object)element);
        return Queue.ofAll(removed.length() == this.length() ? this : removed);
    }

    public Queue<T> removeFirst(Predicate<T> predicate) {
        List removed = this.toList().removeFirst(predicate);
        return Queue.ofAll(removed.length() == this.length() ? this : removed);
    }

    @Override
    public Queue<T> removeAt(int index) {
        return Queue.ofAll(this.toList().removeAt(index));
    }

    public Queue<T> replace(T currentElement, T newElement) {
        List<T> newFront = this.front.replace(currentElement, newElement);
        List<T> newRear = this.rear.replace(currentElement, newElement);
        return newFront.size() + newRear.size() == 0 ? Queue.empty() : (newFront == this.front && newRear == this.rear ? this : new Queue<T>(newFront, newRear));
    }

    @Override
    public Queue<T> reverse() {
        return this.isEmpty() ? this : Queue.ofAll(this.toList().reverse());
    }

    @Override
    public Queue<T> sorted(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        return Queue.ofAll(this.toList().sorted((Comparator)comparator));
    }

    @Override
    public Queue<T> subSequence(int beginIndex, int endIndex) {
        Collections.subSequenceRangeCheck(beginIndex, endIndex, this.length());
        if (beginIndex == endIndex) {
            return Queue.empty();
        }
        if (beginIndex == 0 && endIndex == this.length()) {
            return this;
        }
        return Queue.ofAll(this.toList().subSequence(beginIndex, endIndex));
    }

    @Override
    public Queue<T> tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty " + this.stringPrefix());
        }
        return new Queue<T>(this.front.tail(), this.rear);
    }

    @Override
    public Queue<T> take(int n2) {
        if (n2 <= 0) {
            return Queue.empty();
        }
        if (n2 >= this.length()) {
            return this;
        }
        int frontLength = this.front.length();
        if (n2 < frontLength) {
            return new Queue(this.front.take(n2), List.empty());
        }
        if (n2 == frontLength) {
            return new Queue<T>(this.front, List.empty());
        }
        return new Queue<T>(this.front, this.rear.takeRight(n2 - frontLength));
    }

    @Override
    public Queue<T> update(int index, T element) {
        return Queue.ofAll(this.toList().update(index, (Object)element));
    }

    private Object readResolve() {
        return this.isEmpty() ? EMPTY : this;
    }

    @Override
    public String stringPrefix() {
        return "Queue";
    }

    public boolean equals(Object o2) {
        return Collections.equals(this, o2);
    }

    public int hashCode() {
        return Collections.hashOrdered(this);
    }
}

