/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.dwarf;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.backend.wasm.dwarf.DebugLinesStringTable;
import org.jetbrains.kotlin.backend.wasm.dwarf.DebuggingSection;
import org.jetbrains.kotlin.backend.wasm.dwarf.DwForm;
import org.jetbrains.kotlin.backend.wasm.dwarf.Dwarf;
import org.jetbrains.kotlin.backend.wasm.dwarf.lines.DirectoryId;
import org.jetbrains.kotlin.backend.wasm.dwarf.lines.DirectoryTable;
import org.jetbrains.kotlin.backend.wasm.dwarf.lines.DwLinesHeader;
import org.jetbrains.kotlin.backend.wasm.dwarf.lines.FileId;
import org.jetbrains.kotlin.backend.wasm.dwarf.lines.FileInfo;
import org.jetbrains.kotlin.backend.wasm.dwarf.lines.FileTable;
import org.jetbrains.kotlin.backend.wasm.dwarf.lines.LineInstruction;
import org.jetbrains.kotlin.wasm.ir.convertors.ByteWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 '2\u00020\u0001:\u0003%&'B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\rJ\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\rJ\u000e\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\rJ\u001c\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/backend/wasm/dwarf/LineProgram;", "", "encoding", "Lorg/jetbrains/kotlin/backend/wasm/dwarf/Dwarf$Encoding;", "lineEncoding", "Lorg/jetbrains/kotlin/backend/wasm/dwarf/LineProgram$LineEncoding;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/dwarf/Dwarf$Encoding;Lorg/jetbrains/kotlin/backend/wasm/dwarf/LineProgram$LineEncoding;)V", "files", "Lorg/jetbrains/kotlin/backend/wasm/dwarf/lines/FileTable;", "directories", "Lorg/jetbrains/kotlin/backend/wasm/dwarf/lines/DirectoryTable;", "previousRow", "Lorg/jetbrains/kotlin/backend/wasm/dwarf/LineProgram$LineRow;", "instructions", "", "Lorg/jetbrains/kotlin/backend/wasm/dwarf/lines/LineInstruction;", "addFile", "Lorg/jetbrains/kotlin/backend/wasm/dwarf/lines/FileId;", "file", "Lorg/jetbrains/kotlin/backend/wasm/dwarf/DebugLinesStringTable$StringRef;", "directory", "addFile-__CDEWQ", "(II)I", "startFunction", "", "row", "addEmptyMapping", "addressOffset", "", "endFunction", "add", "write", "section", "Lorg/jetbrains/kotlin/backend/wasm/dwarf/DebuggingSection$DebugLines;", "stringOffsets", "", "LineRow", "LineEncoding", "Companion", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nLineProgram.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineProgram.kt\norg/jetbrains/kotlin/backend/wasm/dwarf/LineProgram\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1#2:175\n*E\n"})
public final class LineProgram {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Dwarf.Encoding encoding;
    @NotNull
    private final LineEncoding lineEncoding;
    @NotNull
    private final FileTable files;
    @NotNull
    private final DirectoryTable directories;
    @NotNull
    private LineRow previousRow;
    @NotNull
    private final List<LineInstruction> instructions;
    @NotNull
    private static final LineRow DEFAULT_ROW = new LineRow(FileId.constructor-impl(-1), 0, 0, 0, null);

    public LineProgram(@NotNull Dwarf.Encoding encoding, @NotNull LineEncoding lineEncoding) {
        Intrinsics.checkNotNullParameter(encoding, "encoding");
        Intrinsics.checkNotNullParameter(lineEncoding, "lineEncoding");
        this.encoding = encoding;
        this.lineEncoding = lineEncoding;
        this.files = new FileTable();
        this.directories = new DirectoryTable();
        this.previousRow = DEFAULT_ROW;
        this.instructions = new ArrayList();
    }

    public /* synthetic */ LineProgram(Dwarf.Encoding encoding, LineEncoding lineEncoding, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            lineEncoding = LineEncoding.Default.INSTANCE;
        }
        this(encoding, lineEncoding);
    }

    public final int addFile-__CDEWQ(int n2, int n3) {
        int dirIndex = ((DirectoryId)this.directories.add(DebugLinesStringTable.StringRef.box-impl(n3))).unbox-impl();
        return ((FileId)this.files.add(new FileInfo(n2, dirIndex, null))).unbox-impl();
    }

    public final void startFunction(@NotNull LineRow row) {
        Intrinsics.checkNotNullParameter(row, "row");
        UtilsKt.push(this.instructions, new LineInstruction.SetAddress(row.getAddressOffset(), this.encoding));
        this.previousRow = LineRow.copy--BySMf0$default(DEFAULT_ROW, 0, row.getAddressOffset(), 0, 0, 13, null);
        this.add(row);
        this.instructions.set(CollectionsKt.getLastIndex(this.instructions), LineInstruction.SetPrologueEnd.INSTANCE);
    }

    public final void addEmptyMapping(int addressOffset) {
        int lastInstructionIndex = CollectionsKt.getLastIndex(this.instructions);
        if (lastInstructionIndex < 0 || !Intrinsics.areEqual(this.instructions.get(lastInstructionIndex), LineInstruction.SetPrologueEnd.INSTANCE)) {
            return;
        }
        int offsetAdvance = addressOffset - this.previousRow.getAddressOffset();
        if (offsetAdvance != 0) {
            this.instructions.set(lastInstructionIndex, LineInstruction.Copy.INSTANCE);
            UtilsKt.push(this.instructions, new LineInstruction.AdvancePC(offsetAdvance));
            UtilsKt.push(this.instructions, LineInstruction.SetPrologueEnd.INSTANCE);
            UtilsKt.push(this.instructions, LineInstruction.Copy.INSTANCE);
            this.previousRow = LineRow.copy--BySMf0$default(this.previousRow, 0, addressOffset, 0, 0, 13, null);
        }
    }

    public final void endFunction(@NotNull LineRow row) {
        Intrinsics.checkNotNullParameter(row, "row");
        this.add(row);
        this.instructions.set(CollectionsKt.getLastIndex(this.instructions), LineInstruction.EndSequence.INSTANCE);
        this.previousRow = DEFAULT_ROW;
    }

    public final void add(@NotNull LineRow row) {
        int offsetAdvance;
        int lineAdvance;
        Intrinsics.checkNotNullParameter(row, "row");
        if (!FileId.equals-impl0(row.getFile-mLAX5ik(), this.previousRow.getFile-mLAX5ik())) {
            UtilsKt.push(this.instructions, new LineInstruction.SetFile(row.getFile-mLAX5ik(), null));
        }
        if (row.getColumn() != this.previousRow.getColumn()) {
            UtilsKt.push(this.instructions, new LineInstruction.SetColumn(row.getColumn()));
        }
        if ((lineAdvance = row.getLine() - this.previousRow.getLine()) != 0) {
            UtilsKt.push(this.instructions, new LineInstruction.AdvanceLine(lineAdvance));
        }
        if ((offsetAdvance = row.getAddressOffset() - this.previousRow.getAddressOffset()) != 0) {
            UtilsKt.push(this.instructions, new LineInstruction.AdvancePC(offsetAdvance));
        }
        UtilsKt.push(this.instructions, LineInstruction.Copy.INSTANCE);
        this.previousRow = row;
    }

    public final void write(@NotNull DebuggingSection.DebugLines section, @NotNull List<Integer> stringOffsets) {
        ByteWriter.OutputStream outputStream;
        ByteWriter.OutputStream $i$a$-require-LineProgram$write$422;
        Intrinsics.checkNotNullParameter(section, "section");
        Intrinsics.checkNotNullParameter(stringOffsets, "stringOffsets");
        if (!(this.encoding.getFormat() == Dwarf.Format.DWARF_32)) {
            boolean $i$a$-require-LineProgram$write$32 = false;
            String $i$a$-require-LineProgram$write$32 = "Unsupported format: " + (Object)((Object)this.encoding.getFormat());
            throw new IllegalArgumentException($i$a$-require-LineProgram$write$32.toString());
        }
        if (!(this.encoding.getVersion() == 5)) {
            boolean $i$a$-require-LineProgram$write$422 = false;
            String $i$a$-require-LineProgram$write$422 = "Unsupported DWARF version: " + this.encoding.getVersion();
            throw new IllegalArgumentException($i$a$-require-LineProgram$write$422.toString());
        }
        ByteWriter.OutputStream $this$write_u24lambda_u242 = $i$a$-require-LineProgram$write$422 = section.getWriter().createTemp();
        boolean bl = false;
        $this$write_u24lambda_u242.writeUInt16-xj2QHRw(UShort.constructor-impl((short)this.encoding.getVersion()));
        $this$write_u24lambda_u242.writeUByte-7apg3OU(UByte.constructor-impl((byte)this.encoding.getAddressSize()));
        $this$write_u24lambda_u242.writeByte((byte)0);
        ByteWriter.OutputStream sectionEpilogue = $i$a$-require-LineProgram$write$422;
        ByteWriter.OutputStream $this$write_u24lambda_u243 = $this$write_u24lambda_u242 = section.getWriter().createTemp();
        boolean bl2 = false;
        $this$write_u24lambda_u243.writeUByte-7apg3OU(this.lineEncoding.getMinimumInstructionLength-w2LRezQ());
        $this$write_u24lambda_u243.writeUByte-7apg3OU(this.lineEncoding.getMaximumOperandsPerInstruction-w2LRezQ());
        $this$write_u24lambda_u243.writeBoolean(this.lineEncoding.getDefaultIsStatement());
        $this$write_u24lambda_u243.writeByte(this.lineEncoding.getLineBase());
        $this$write_u24lambda_u243.writeUByte-7apg3OU(this.lineEncoding.getLineRange-w2LRezQ());
        $this$write_u24lambda_u243.writeUByte-7apg3OU((byte)13);
        Object object = new byte[]{0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 1};
        $this$write_u24lambda_u243.writeBytes((byte[])object);
        $this$write_u24lambda_u243.writeUByte-7apg3OU((byte)1);
        $this$write_u24lambda_u243.writeVarUInt32-WZ4Q5Ns(DwLinesHeader.PATH.getOpcode-pVg5ArA());
        $this$write_u24lambda_u243.writeVarUInt32-WZ4Q5Ns(DwForm.LINE_STRP.getOpcode-pVg5ArA());
        $this$write_u24lambda_u243.writeVarUInt32-WZ4Q5Ns(UInt.constructor-impl(this.directories.getSize()));
        object = this.directories.iterator();
        while (object.hasNext()) {
            int dir2 = ((DebugLinesStringTable.StringRef)object.next()).unbox-impl();
            $this$write_u24lambda_u243.writeUInt64-4PLdz1A(ULong.constructor-impl(((Number)stringOffsets.get(dir2 - 1)).intValue()), this.encoding.getFormat().getWordSize());
        }
        $this$write_u24lambda_u243.writeUByte-7apg3OU((byte)2);
        $this$write_u24lambda_u243.writeVarUInt32-WZ4Q5Ns(DwLinesHeader.PATH.getOpcode-pVg5ArA());
        $this$write_u24lambda_u243.writeVarUInt32-WZ4Q5Ns(DwForm.LINE_STRP.getOpcode-pVg5ArA());
        $this$write_u24lambda_u243.writeVarUInt32-WZ4Q5Ns(DwLinesHeader.DIRECTORY_INDEX.getOpcode-pVg5ArA());
        $this$write_u24lambda_u243.writeVarUInt32-WZ4Q5Ns(DwForm.UDATA.getOpcode-pVg5ArA());
        $this$write_u24lambda_u243.writeVarUInt32-WZ4Q5Ns(UInt.constructor-impl(this.files.getSize()));
        for (FileInfo file : this.files) {
            $this$write_u24lambda_u243.writeUInt64-4PLdz1A(ULong.constructor-impl(((Number)stringOffsets.get(file.getPath-ADB0z2I() - 1)).intValue()), this.encoding.getFormat().getWordSize());
            $this$write_u24lambda_u243.writeVarUInt32-WZ4Q5Ns(UInt.constructor-impl(file.getDirectory-XSarpg0()));
        }
        ByteWriter.OutputStream header = $this$write_u24lambda_u242;
        ByteWriter.OutputStream $this$write_u24lambda_u244 = outputStream = section.getWriter().createTemp();
        boolean bl3 = false;
        $this$write_u24lambda_u244.writeUInt64-4PLdz1A(ULong.constructor-impl(header.getWritten()), this.encoding.getFormat().getWordSize());
        $this$write_u24lambda_u244.write(header);
        for (LineInstruction instruction : this.instructions) {
            instruction.writeTo($this$write_u24lambda_u244);
        }
        ByteWriter.OutputStream wholeSectionWithoutLength = outputStream;
        ByteWriter.OutputStream $this$write_u24lambda_u245 = section.getWriter();
        boolean bl4 = false;
        $this$write_u24lambda_u245.writeUInt64-4PLdz1A(ULong.constructor-impl(wholeSectionWithoutLength.getWritten() + sectionEpilogue.getWritten()), this.encoding.getFormat().getWordSize());
        $this$write_u24lambda_u245.write(sectionEpilogue);
        $this$write_u24lambda_u245.write(wholeSectionWithoutLength);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/dwarf/LineProgram$Companion;", "", "<init>", "()V", "DEFAULT_ROW", "Lorg/jetbrains/kotlin/backend/wasm/dwarf/LineProgram$LineRow;", "backend.wasm"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001:\u0001\u0011R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0005R\u0012\u0010\t\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0005R\u0012\u0010\u000b\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0005R\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0012\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/dwarf/LineProgram$LineEncoding;", "", "lineBase", "", "getLineBase", "()B", "lineRange", "Lkotlin/UByte;", "getLineRange-w2LRezQ", "minimumInstructionLength", "getMinimumInstructionLength-w2LRezQ", "maximumOperandsPerInstruction", "getMaximumOperandsPerInstruction-w2LRezQ", "defaultIsStatement", "", "getDefaultIsStatement", "()Z", "Default", "backend.wasm"})
    public static interface LineEncoding {
        public byte getLineBase();

        public byte getLineRange-w2LRezQ();

        public byte getMinimumInstructionLength-w2LRezQ();

        public byte getMaximumOperandsPerInstruction-w2LRezQ();

        public boolean getDefaultIsStatement();

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\n\u0010\u0007R\u0016\u0010\f\u001a\u00020\tX\u0096D\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\r\u0010\u0007R\u0016\u0010\u000e\u001a\u00020\tX\u0096D\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\u000f\u0010\u0007R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/dwarf/LineProgram$LineEncoding$Default;", "Lorg/jetbrains/kotlin/backend/wasm/dwarf/LineProgram$LineEncoding;", "<init>", "()V", "lineBase", "", "getLineBase", "()B", "lineRange", "Lkotlin/UByte;", "getLineRange-w2LRezQ", "B", "minimumInstructionLength", "getMinimumInstructionLength-w2LRezQ", "maximumOperandsPerInstruction", "getMaximumOperandsPerInstruction-w2LRezQ", "defaultIsStatement", "", "getDefaultIsStatement", "()Z", "backend.wasm"})
        public static final class Default
        implements LineEncoding {
            @NotNull
            public static final Default INSTANCE = new Default();
            private static final byte lineBase = (byte)-5;
            private static final byte lineRange = (byte)14;
            private static final byte minimumInstructionLength = 1;
            private static final byte maximumOperandsPerInstruction = 1;
            private static final boolean defaultIsStatement = true;

            private Default() {
            }

            @Override
            public byte getLineBase() {
                return lineBase;
            }

            @Override
            public byte getLineRange-w2LRezQ() {
                return lineRange;
            }

            @Override
            public byte getMinimumInstructionLength-w2LRezQ() {
                return minimumInstructionLength;
            }

            @Override
            public byte getMaximumOperandsPerInstruction-w2LRezQ() {
                return maximumOperandsPerInstruction;
            }

            @Override
            public boolean getDefaultIsStatement() {
                return defaultIsStatement;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u000bJ\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J8\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0013\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/dwarf/LineProgram$LineRow;", "", "file", "Lorg/jetbrains/kotlin/backend/wasm/dwarf/lines/FileId;", "addressOffset", "", "line", "column", "<init>", "(IIIILkotlin/jvm/internal/DefaultConstructorMarker;)V", "getFile-mLAX5ik", "()I", "I", "getAddressOffset", "getLine", "getColumn", "component1", "component1-mLAX5ik", "component2", "component3", "component4", "copy", "copy--BySMf0", "(IIII)Lorg/jetbrains/kotlin/backend/wasm/dwarf/LineProgram$LineRow;", "equals", "", "other", "hashCode", "toString", "", "backend.wasm"})
    public static final class LineRow {
        private final int file;
        private final int addressOffset;
        private final int line;
        private final int column;

        private LineRow(int file, int addressOffset, int line, int column) {
            this.file = file;
            this.addressOffset = addressOffset;
            this.line = line;
            this.column = column;
        }

        public final int getFile-mLAX5ik() {
            return this.file;
        }

        public final int getAddressOffset() {
            return this.addressOffset;
        }

        public final int getLine() {
            return this.line;
        }

        public final int getColumn() {
            return this.column;
        }

        public final int component1-mLAX5ik() {
            return this.file;
        }

        public final int component2() {
            return this.addressOffset;
        }

        public final int component3() {
            return this.line;
        }

        public final int component4() {
            return this.column;
        }

        @NotNull
        public final LineRow copy--BySMf0(int n2, int addressOffset, int line, int column) {
            return new LineRow(n2, addressOffset, line, column, null);
        }

        public static /* synthetic */ LineRow copy--BySMf0$default(LineRow lineRow, int n2, int n3, int n4, int n5, int n6, Object object) {
            if ((n6 & 1) != 0) {
                n2 = lineRow.file;
            }
            if ((n6 & 2) != 0) {
                n3 = lineRow.addressOffset;
            }
            if ((n6 & 4) != 0) {
                n4 = lineRow.line;
            }
            if ((n6 & 8) != 0) {
                n5 = lineRow.column;
            }
            return lineRow.copy--BySMf0(n2, n3, n4, n5);
        }

        @NotNull
        public String toString() {
            return "LineRow(file=" + FileId.toString-impl(this.file) + ", addressOffset=" + this.addressOffset + ", line=" + this.line + ", column=" + this.column + ')';
        }

        public int hashCode() {
            int result2 = FileId.hashCode-impl(this.file);
            result2 = result2 * 31 + Integer.hashCode(this.addressOffset);
            result2 = result2 * 31 + Integer.hashCode(this.line);
            result2 = result2 * 31 + Integer.hashCode(this.column);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LineRow)) {
                return false;
            }
            LineRow lineRow = (LineRow)other;
            if (!FileId.equals-impl0(this.file, lineRow.file)) {
                return false;
            }
            if (this.addressOffset != lineRow.addressOffset) {
                return false;
            }
            if (this.line != lineRow.line) {
                return false;
            }
            return this.column == lineRow.column;
        }

        public /* synthetic */ LineRow(int file, int addressOffset, int line, int column, DefaultConstructorMarker $constructor_marker) {
            this(file, addressOffset, line, column);
        }
    }
}

