/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.hsqldb.Column;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Trace;
import org.hsqldb.jdbc.Util;
import org.hsqldb.jdbc.jdbcBlob;
import org.hsqldb.jdbc.jdbcClob;
import org.hsqldb.jdbc.jdbcConnection;
import org.hsqldb.jdbc.jdbcParameterMetaData;
import org.hsqldb.jdbc.jdbcResultSet;
import org.hsqldb.jdbc.jdbcResultSetMetaData;
import org.hsqldb.jdbc.jdbcStatement;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public class jdbcPreparedStatement
extends jdbcStatement
implements PreparedStatement {
    protected Object[] parameterValues;
    protected boolean[] parameterSet;
    protected boolean[] parameterStream;
    protected int[] parameterTypes;
    protected int[] parameterModes;
    protected int[] streamLengths;
    protected boolean hasStreams;
    protected Result rsmdDescriptor;
    protected Result pmdDescriptor;
    protected jdbcResultSetMetaData rsmd;
    protected Object pmd;
    protected String sql;
    protected int statementID;
    protected boolean isRowCount;

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.checkClosed();
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        this.resultIn = null;
        try {
            this.resultOut.setMaxRows(this.maxRows);
            this.resultOut.setParameterData(this.parameterValues);
            this.resultIn = this.connection.sessionProxy.execute(this.resultOut);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
        if (this.resultIn.isError()) {
            Util.throwError(this.resultIn);
        }
        return this.resultIn.isData();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        this.checkIsRowCount(false);
        this.checkParametersSet();
        this.resultIn = null;
        try {
            this.resultOut.setMaxRows(this.maxRows);
            this.resultOut.setParameterData(this.parameterValues);
            this.resultIn = this.connection.sessionProxy.execute(this.resultOut);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
        if (this.resultIn.isError()) {
            Util.throwError(this.resultIn);
        } else if (!this.resultIn.isData()) {
            String string = "Expected but did not recieve a result set";
            throw Util.sqlException(85, string);
        }
        return new jdbcResultSet(this, this.resultIn, this.connection.connProperties, this.connection.isNetConn);
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        this.checkIsRowCount(true);
        this.checkParametersSet();
        this.resultIn = null;
        try {
            this.resultOut.setParameterData(this.parameterValues);
            this.resultIn = this.connection.sessionProxy.execute(this.resultOut);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
        if (this.resultIn.isError()) {
            Util.throwError(this.resultIn);
        } else if (this.resultIn.mode != 1) {
            String string = "Expected but did not recieve a row update count";
            throw Util.sqlException(85, string);
        }
        return this.resultIn.getUpdateCount();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (this.batchResultOut == null) {
            this.batchResultOut = new Result(9, this.parameterTypes, this.statementID);
        }
        return super.executeBatch();
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        this.setParameter(n, null);
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.setParameter(n, bl2);
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        this.setIntParameter(n, by);
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        this.setIntParameter(n, s);
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        this.setIntParameter(n, n2);
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        this.setLongParameter(n, l);
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        this.setDouble(n, f);
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        Double d2 = new Double(d);
        this.setParameter(n, d2);
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.setParameter(n, bigDecimal);
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        this.setParameter(n, string);
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.setParameter(n, byArray);
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        this.setParameter(n, date);
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        this.setParameter(n, time);
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setParameter(n, timestamp);
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkSetParameterIndex(n, true);
        if (inputStream == null) {
            String string = "input stream is null";
            throw Util.sqlException(62, string);
        }
        try {
            String string = StringConverter.inputStreamToString(inputStream, n2);
            this.setParameter(n, string);
        }
        catch (IOException iOException) {
            throw Util.sqlException(81);
        }
    }

    @Override
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkSetParameterIndex(n, true);
        String string = null;
        if (inputStream == null) {
            string = "input stream is null";
        } else if (n2 % 2 != 0) {
            string = "odd length argument";
        }
        if (string != null) {
            throw Util.sqlException(62, string);
        }
        int n3 = n2 / 2;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n4;
            int n5;
            for (int i = 0; i < n3 && (n5 = inputStream.read()) != -1 && (n4 = inputStream.read()) != -1; ++i) {
                stringBuffer.append((char)(n5 << 8 | n4));
            }
        }
        catch (IOException iOException) {
            throw Util.sqlException(19);
        }
        this.setParameter(n, stringBuffer.toString());
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkSetParameterIndex(n, true);
        if (inputStream == null) {
            throw Util.sqlException(Trace.error(62, 176));
        }
        HsqlByteArrayOutputStream hsqlByteArrayOutputStream = null;
        try {
            int n3;
            hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream();
            int n4 = 2048;
            byte[] byArray = new byte[n4];
            for (int i = n2; i > 0 && (n3 = inputStream.read(byArray, 0, i > n4 ? n4 : i)) != -1; i -= n3) {
                hsqlByteArrayOutputStream.write(byArray, 0, n3);
            }
            this.setParameter(n, hsqlByteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw Util.sqlException(34, iOException.toString());
        }
        finally {
            if (hsqlByteArrayOutputStream != null) {
                try {
                    hsqlByteArrayOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkClosed();
        ArrayUtil.fillArray(this.parameterValues, null);
        ArrayUtil.clearArray(90, this.parameterSet, 0, this.parameterSet.length);
        if (this.parameterStream != null) {
            ArrayUtil.clearArray(90, this.parameterStream, 0, this.parameterStream.length);
        }
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.setObject(n, object);
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object);
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        this.setParameter(n, object);
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkClosed();
        int n = this.parameterValues.length;
        Object[] objectArray = new Object[n];
        this.checkParametersSet();
        System.arraycopy(this.parameterValues, 0, objectArray, 0, n);
        if (this.batchResultOut == null) {
            this.batchResultOut = new Result(9, this.parameterTypes, this.statementID);
        }
        this.batchResultOut.add(objectArray);
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkSetParameterIndex(n, true);
        if (reader == null) {
            String string = "reader is null";
            throw Util.sqlException(62, string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[2048];
        try {
            int n3;
            for (int i = n2; i > 0 && (n3 = reader.read(cArray, 0, i > 2048 ? 2048 : i)) != -1; i -= n3) {
                stringBuffer.append(cArray, 0, n3);
            }
        }
        catch (IOException iOException) {
            throw Util.sqlException(19, iOException.toString());
        }
        this.setParameter(n, stringBuffer.toString());
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        if (blob instanceof jdbcBlob) {
            this.setParameter(n, ((jdbcBlob)blob).data);
            return;
        }
        if (blob == null) {
            this.setParameter(n, null);
            return;
        }
        this.checkSetParameterIndex(n, false);
        long l = blob.length();
        if (l > Integer.MAX_VALUE) {
            String string = "Maximum Blob input octet length exceeded: " + l;
            throw Util.sqlException(34, string);
        }
        HsqlByteArrayOutputStream hsqlByteArrayOutputStream = null;
        try {
            int n2;
            hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream();
            InputStream inputStream = blob.getBinaryStream();
            int n3 = 2048;
            byte[] byArray = new byte[n3];
            for (int i = (int)l; i > 0 && (n2 = inputStream.read(byArray, 0, i > n3 ? n3 : i)) != -1; i -= n2) {
                hsqlByteArrayOutputStream.write(byArray, 0, n2);
            }
            this.setParameter(n, hsqlByteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw Util.sqlException(34, iOException.toString());
        }
        finally {
            if (hsqlByteArrayOutputStream != null) {
                try {
                    hsqlByteArrayOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        if (clob instanceof jdbcClob) {
            this.setParameter(n, ((jdbcClob)clob).data);
            return;
        }
        if (clob == null) {
            this.setParameter(n, null);
            return;
        }
        this.checkSetParameterIndex(n, false);
        long l = clob.length();
        if (l > Integer.MAX_VALUE) {
            String string = "Max Clob input character length exceeded: " + l;
            throw Util.sqlException(34, string);
        }
        Reader reader = clob.getCharacterStream();
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[2048];
        try {
            int n2;
            for (int i = (int)l; i > 0 && (n2 = reader.read(cArray, 0, i > 2048 ? 2048 : i)) != -1; i -= n2) {
                stringBuffer.append(cArray, 0, n2);
            }
        }
        catch (IOException iOException) {
            throw Util.sqlException(19, iOException.toString());
        }
        this.setParameter(n, stringBuffer.toString());
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.isRowCount) {
            return null;
        }
        if (this.rsmd == null) {
            this.rsmd = new jdbcResultSetMetaData(this.rsmdDescriptor, this.connection.connProperties);
        }
        return this.rsmd;
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        String string;
        try {
            string = HsqlDateTime.getDateString(date, calendar);
        }
        catch (Exception exception) {
            throw Util.sqlException(7, exception.toString());
        }
        this.setParameter(n, string);
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        String string;
        try {
            string = HsqlDateTime.getTimeString(time, calendar);
        }
        catch (Exception exception) {
            throw Util.sqlException(7, exception.toString());
        }
        this.setParameter(n, string);
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.checkSetParameterIndex(n, false);
        if (calendar != null && timestamp != null) {
            int n2 = timestamp.getNanos();
            timestamp = new Timestamp(HsqlDateTime.getTimeInMillis(timestamp, calendar, null));
            timestamp.setNanos(n2);
        }
        this.setParameter(n, timestamp);
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        this.setParameter(n, null);
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        if (this.pmd == null) {
            this.pmd = new jdbcParameterMetaData(this.pmdDescriptor);
        }
        return (ParameterMetaData)this.pmd;
    }

    jdbcPreparedStatement(jdbcConnection jdbcConnection2, String string, int n) throws HsqlException, SQLException {
        super(jdbcConnection2, n);
        string = jdbcConnection2.nativeSQL(string);
        this.resultOut.setResultType(65555);
        this.resultOut.setMainString(string);
        Result result = this.connection.sessionProxy.execute(this.resultOut);
        if (result.isError()) {
            Util.throwError(result);
        }
        Iterator iterator = result.iterator();
        try {
            Object[] objectArray = (Object[])iterator.next();
            this.statementID = ((Result)objectArray[0]).getStatementID();
            objectArray = (Object[])iterator.next();
            this.rsmdDescriptor = (Result)objectArray[0];
            this.isRowCount = this.rsmdDescriptor.mode == 1;
            objectArray = (Object[])iterator.next();
            this.pmdDescriptor = (Result)objectArray[0];
            this.parameterTypes = this.pmdDescriptor.metaData.getParameterTypes();
            this.parameterValues = new Object[this.parameterTypes.length];
            this.parameterSet = new boolean[this.parameterTypes.length];
            this.parameterModes = this.pmdDescriptor.metaData.paramMode;
        }
        catch (Exception exception) {
            throw Trace.error(40, exception.toString());
        }
        this.resultOut = new Result(65548, this.parameterTypes, this.statementID);
        this.sql = string;
    }

    protected void checkIsRowCount(boolean bl) throws SQLException {
        if (bl != this.isRowCount) {
            int n = bl ? 154 : 155;
            throw Util.sqlException(n);
        }
    }

    protected void checkSetParameterIndex(int n, boolean bl) throws SQLException {
        this.checkClosed();
        if (n < 1 || n > this.parameterValues.length) {
            String string = "parameter index out of range: " + n;
            throw Util.sqlException(62, string);
        }
        if (bl) {
            if (this.parameterStream == null) {
                this.parameterStream = new boolean[this.parameterTypes.length];
            }
            this.parameterStream[n - 1] = true;
            this.parameterSet[n - 1] = false;
        } else {
            this.parameterSet[n - 1] = true;
        }
    }

    private void checkParametersSet() throws SQLException {
    }

    private void setParameter(int n, Object object) throws SQLException {
        this.checkSetParameterIndex(n, false);
        --n;
        if (object == null) {
            this.parameterValues[n] = null;
            return;
        }
        int n2 = this.parameterTypes[n];
        try {
            switch (n2) {
                case 1111: {
                    object = new JavaObject((Serializable)object);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    if (!(object instanceof byte[])) {
                        throw Util.sqlException(Trace.error(95));
                    }
                    object = new Binary((byte[])object, !this.connection.isNetConn);
                    break;
                }
                case 91: {
                    if (object instanceof java.util.Date) {
                        long l = HsqlDateTime.getNormalisedDate(((java.util.Date)object).getTime());
                        object = new Date(l);
                        break;
                    }
                    object = Column.convertObject(object, n2);
                    break;
                }
                case 92: {
                    if (object instanceof java.util.Date) {
                        long l = HsqlDateTime.getNormalisedTime(((java.util.Date)object).getTime());
                        object = new Time(l);
                        break;
                    }
                    object = Column.convertObject(object, n2);
                    break;
                }
                case 93: {
                    if (object instanceof Timestamp) {
                        long l = ((Timestamp)object).getTime();
                        int n3 = ((Timestamp)object).getNanos();
                        object = new Timestamp(l);
                        ((Timestamp)object).setNanos(n3);
                        break;
                    }
                    object = Column.convertObject(object, n2);
                    break;
                }
                default: {
                    object = Column.convertObject(object, n2);
                    break;
                }
            }
        }
        catch (HsqlException hsqlException) {
            Util.throwError(hsqlException);
        }
        this.parameterValues[n] = object;
    }

    private void setIntParameter(int n, int n2) throws SQLException {
        this.checkSetParameterIndex(n, false);
        int n3 = this.parameterTypes[n - 1];
        switch (n3) {
            case -6: 
            case 4: 
            case 5: {
                Integer n4 = new Integer(n2);
                this.parameterValues[n - 1] = n4;
                break;
            }
            default: {
                this.setLongParameter(n, n2);
            }
        }
    }

    private void setLongParameter(int n, long l) throws SQLException {
        this.checkSetParameterIndex(n, false);
        int n2 = this.parameterTypes[n - 1];
        switch (n2) {
            case -5: {
                Long l2 = new Long(l);
                this.parameterValues[n - 1] = l2;
                break;
            }
            case -2: 
            case 1111: {
                throw Util.sqlException(Trace.error(95));
            }
            default: {
                this.setParameter(n, new Long(l));
            }
        }
    }

    @Override
    public void addBatch(String string) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public boolean execute(String string) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        HsqlException hsqlException = null;
        try {
            if (!this.connection.isClosed) {
                this.connection.sessionProxy.execute(Result.newFreeStmtRequest(this.statementID));
            }
        }
        catch (HsqlException hsqlException2) {
            hsqlException = hsqlException2;
        }
        this.parameterValues = null;
        this.parameterSet = null;
        this.parameterStream = null;
        this.parameterTypes = null;
        this.parameterModes = null;
        this.rsmdDescriptor = null;
        this.pmdDescriptor = null;
        this.rsmd = null;
        this.pmd = null;
        super.close();
        if (hsqlException != null) {
            throw Util.sqlException(hsqlException);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        String string = this.sql;
        Object[] objectArray = this.parameterValues;
        if (string == null || objectArray == null) {
            stringBuffer.append("[closed]");
            return stringBuffer.toString();
        }
        stringBuffer.append("[sql=[").append(string).append("]");
        if (objectArray.length > 0) {
            stringBuffer.append(", parameters=[");
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append('[');
                stringBuffer.append(objectArray[i]);
                stringBuffer.append("], ");
            }
            stringBuffer.setLength(stringBuffer.length() - 2);
            stringBuffer.append(']');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

