/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.Calc.NLPSolver;

import com.sun.star.awt.XReschedule;
import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertyChangeListener;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.beans.XVetoableChangeListener;
import com.sun.star.chart.XChartDataArray;
import com.sun.star.comp.Calc.NLPSolver.PropertyInfo;
import com.sun.star.comp.Calc.NLPSolver.ResourceManager;
import com.sun.star.container.XIndexAccess;
import com.sun.star.document.XEmbeddedObjectSupplier;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.Locale;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XLocalizable;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.sheet.SolverConstraint;
import com.sun.star.sheet.SolverConstraintOperator;
import com.sun.star.sheet.XSolver;
import com.sun.star.sheet.XSolverDescription;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.CellAddress;
import com.sun.star.table.CellContentType;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCell;
import com.sun.star.table.XTableChartsSupplier;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseNLPSolver
extends WeakBase
implements XLocalizable,
XSolver,
XSolverDescription,
XPropertySet,
XPropertySetInfo {
    protected final XComponentContext m_xContext;
    private final String m_name;
    private final ArrayList<PropertyInfo> m_properties = new ArrayList();
    private final HashMap<String, PropertyInfo> m_propertyMap = new HashMap();
    private Locale m_locale = new Locale();
    private final ResourceManager resourceManager;
    private CellAddress m_objective;
    protected CellAddress[] m_variables;
    protected SolverConstraint[] m_constraints;
    private XSpreadsheetDocument m_document;
    private XModel m_xModel;
    protected XReschedule m_xReschedule;
    protected ExtSolverConstraint[] m_extConstraints;
    protected boolean m_maximize;
    protected int m_variableCount;
    protected int m_constraintCount;
    protected int m_cellRangeCount;
    protected XCell m_objectiveCell;
    protected XCell[] m_variableCells;
    protected XChartDataArray[] m_cellRangeData;
    protected CellMap[] m_variableMap;
    protected double[][][] m_variableData;
    protected double m_functionValue;
    protected double[] m_currentParameters;
    protected boolean m_success = false;
    protected PropertyInfo<Boolean> m_assumeNonNegative = new PropertyInfo<Boolean>("AssumeNonNegative", false, "Assume Non-Negative Variables");

    public BaseNLPSolver(XComponentContext xComponentContext, String string) {
        this.m_xContext = xComponentContext;
        this.m_name = string;
        this.m_objective = new CellAddress();
        this.m_variables = new CellAddress[0];
        this.m_constraints = new SolverConstraint[0];
        XMultiComponentFactory xMultiComponentFactory = xComponentContext.getServiceManager();
        try {
            Object object = xMultiComponentFactory.createInstanceWithContext("com.sun.star.awt.Toolkit", xComponentContext);
            this.m_xReschedule = (XReschedule)UnoRuntime.queryInterface(XReschedule.class, (Object)object);
        }
        catch (Exception exception) {
            Logger.getLogger(BaseNLPSolver.class.getName()).log(Level.SEVERE, null, exception);
        }
        this.resourceManager = new ResourceManager(xComponentContext, "com.sun.star.comp.Calc.NLPSolver", "/locale", "NLPSolverCommon");
        this.registerProperty(this.m_assumeNonNegative);
    }

    protected void registerProperty(PropertyInfo propertyInfo) {
        this.m_properties.add(propertyInfo);
        this.m_propertyMap.put(propertyInfo.getProperty().Name, propertyInfo);
        propertyInfo.localize(this.resourceManager);
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public XSpreadsheetDocument getDocument() {
        return this.m_document;
    }

    public void setDocument(XSpreadsheetDocument xSpreadsheetDocument) {
        this.m_document = xSpreadsheetDocument;
        this.m_xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.m_document);
    }

    public CellAddress getObjective() {
        return this.m_objective;
    }

    public void setObjective(CellAddress cellAddress) {
        this.m_objective = cellAddress;
        this.m_objectiveCell = this.getCell(cellAddress);
    }

    public CellAddress[] getVariables() {
        return this.m_variables;
    }

    public void setVariables(CellAddress[] cellAddressArray) {
        int n;
        int n2;
        this.m_variables = cellAddressArray;
        this.m_variableCount = cellAddressArray.length;
        this.m_variableCells = new XCell[this.m_variableCount];
        this.m_currentParameters = new double[this.m_variableCount];
        for (int i = 0; i < this.m_variableCount; ++i) {
            this.m_variableCells[i] = this.getCell(cellAddressArray[i]);
            this.m_currentParameters[i] = this.m_variableCells[i].getValue();
        }
        this.m_variableMap = new CellMap[this.m_variableCount];
        this.m_variableData = new double[this.m_variableCount][][];
        ArrayList<RowInfo> arrayList = new ArrayList<RowInfo>();
        RowInfo rowInfo = null;
        short s = -1;
        int n3 = -1;
        for (int i = 0; i < this.m_variableCount; ++i) {
            boolean bl;
            boolean bl2 = bl = s == this.m_variables[i].Sheet && n3 == this.m_variables[i].Row;
            assert (!bl || rowInfo != null);
            if (bl && rowInfo.EndCol == this.m_variables[i].Column - 1) {
                rowInfo.EndCol++;
                continue;
            }
            rowInfo = new RowInfo(this.m_variables[i].Sheet, this.m_variables[i].Row);
            rowInfo.StartCol = this.m_variables[i].Column;
            rowInfo.EndCol = this.m_variables[i].Column;
            arrayList.add(rowInfo);
            s = rowInfo.Sheet;
            n3 = rowInfo.Row;
        }
        ArrayList<CellRangeAddress> arrayList2 = new ArrayList<CellRangeAddress>();
        if (arrayList.size() > 0) {
            RowInfo rowInfo2 = (RowInfo)arrayList.get(0);
            n2 = 0;
            for (n = 1; n < arrayList.size(); ++n) {
                rowInfo = (RowInfo)arrayList.get(n);
                if (rowInfo.Sheet != rowInfo2.Sheet || rowInfo.Row != rowInfo2.Row + n2 + 1 || rowInfo.StartCol != rowInfo2.StartCol || rowInfo.EndCol != rowInfo2.EndCol) {
                    arrayList2.add(rowInfo2.getCellRangeAddress(rowInfo2.Row + n2));
                    rowInfo2 = rowInfo;
                    n2 = 0;
                    continue;
                }
                ++n2;
            }
            arrayList2.add(rowInfo2.getCellRangeAddress(rowInfo2.Row + n2));
        }
        this.m_cellRangeCount = arrayList2.size();
        this.m_cellRangeData = new XChartDataArray[this.m_cellRangeCount];
        int n4 = 0;
        for (n2 = 0; n2 < this.m_cellRangeCount; ++n2) {
            for (n = 0; n <= ((CellRangeAddress)arrayList2.get((int)n2)).EndRow - ((CellRangeAddress)arrayList2.get((int)n2)).StartRow; ++n) {
                int n5 = 0;
                while (n5 <= ((CellRangeAddress)arrayList2.get((int)n2)).EndColumn - ((CellRangeAddress)arrayList2.get((int)n2)).StartColumn) {
                    CellMap cellMap = new CellMap();
                    this.m_variableMap[n4++] = cellMap;
                    cellMap.Range = n2;
                    cellMap.Col = n5++;
                    cellMap.Row = n;
                }
            }
            this.m_cellRangeData[n2] = this.getChartDataArray((CellRangeAddress)arrayList2.get(n2));
            this.m_variableData[n2] = this.m_cellRangeData[n2].getData();
        }
    }

    public SolverConstraint[] getConstraints() {
        return this.m_constraints;
    }

    public void setConstraints(SolverConstraint[] solverConstraintArray) {
        this.m_constraints = solverConstraintArray;
        this.m_constraintCount = solverConstraintArray.length;
        this.m_extConstraints = new ExtSolverConstraint[this.m_constraintCount];
        for (int i = 0; i < this.m_constraintCount; ++i) {
            this.m_extConstraints[i] = new ExtSolverConstraint(this.getCell(solverConstraintArray[i].Left), solverConstraintArray[i].Operator, solverConstraintArray[i].Right);
        }
    }

    public boolean getMaximize() {
        return this.m_maximize;
    }

    public void setMaximize(boolean bl) {
        this.m_maximize = bl;
    }

    public boolean getSuccess() {
        return this.m_success;
    }

    public double getResultValue() {
        return this.m_functionValue;
    }

    public double[] getSolution() {
        return this.m_currentParameters;
    }

    private XCell getCell(CellAddress cellAddress) {
        return this.getCell(cellAddress.Column, cellAddress.Row, cellAddress.Sheet);
    }

    private XCell getCell(int n, int n2, int n3) {
        try {
            XSpreadsheets xSpreadsheets = this.m_document.getSheets();
            XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xSpreadsheets);
            XSpreadsheet xSpreadsheet = (XSpreadsheet)UnoRuntime.queryInterface(XSpreadsheet.class, (Object)xIndexAccess.getByIndex(n3));
            return xSpreadsheet.getCellByPosition(n, n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Logger.getLogger(BaseNLPSolver.class.getName()).log(Level.SEVERE, null, indexOutOfBoundsException);
        }
        catch (WrappedTargetException wrappedTargetException) {
            Logger.getLogger(BaseNLPSolver.class.getName()).log(Level.SEVERE, null, wrappedTargetException);
        }
        return null;
    }

    private XChartDataArray getChartDataArray(CellRangeAddress cellRangeAddress) {
        return this.getChartDataArray(cellRangeAddress.Sheet, cellRangeAddress.StartColumn, cellRangeAddress.StartRow, cellRangeAddress.EndColumn, cellRangeAddress.EndRow);
    }

    private XChartDataArray getChartDataArray(int n, int n2, int n3, int n4, int n5) {
        try {
            XSpreadsheets xSpreadsheets = this.m_document.getSheets();
            XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xSpreadsheets);
            XSpreadsheet xSpreadsheet = (XSpreadsheet)UnoRuntime.queryInterface(XSpreadsheet.class, (Object)xIndexAccess.getByIndex(n));
            return (XChartDataArray)UnoRuntime.queryInterface(XChartDataArray.class, (Object)xSpreadsheet.getCellRangeByPosition(n2, n3, n4, n5));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Logger.getLogger(BaseNLPSolver.class.getName()).log(Level.SEVERE, null, indexOutOfBoundsException);
        }
        catch (WrappedTargetException wrappedTargetException) {
            Logger.getLogger(BaseNLPSolver.class.getName()).log(Level.SEVERE, null, wrappedTargetException);
        }
        return null;
    }

    protected void initializeSolve() {
        this.lockDocument();
    }

    protected void finalizeSolve() {
        this.unlockDocument();
    }

    public String getComponentDescription() {
        return this.m_name;
    }

    public String getStatusDescription() {
        return "";
    }

    public String getPropertyDescription(String string) {
        PropertyInfo propertyInfo = this.m_propertyMap.get(string);
        if (propertyInfo != null) {
            return propertyInfo.getDescription();
        }
        return "";
    }

    public XPropertySetInfo getPropertySetInfo() {
        return this;
    }

    public void setPropertyValue(String string, Object object) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        PropertyInfo propertyInfo = this.m_propertyMap.get(string);
        if (propertyInfo == null) {
            throw new UnknownPropertyException();
        }
        propertyInfo.setValue(object);
    }

    public Object getPropertyValue(String string) throws UnknownPropertyException, WrappedTargetException {
        PropertyInfo propertyInfo = this.m_propertyMap.get(string);
        if (propertyInfo != null) {
            return propertyInfo.getValue();
        }
        throw new UnknownPropertyException();
    }

    public void addPropertyChangeListener(String string, XPropertyChangeListener xPropertyChangeListener) throws UnknownPropertyException, WrappedTargetException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removePropertyChangeListener(String string, XPropertyChangeListener xPropertyChangeListener) throws UnknownPropertyException, WrappedTargetException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addVetoableChangeListener(String string, XVetoableChangeListener xVetoableChangeListener) throws UnknownPropertyException, WrappedTargetException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeVetoableChangeListener(String string, XVetoableChangeListener xVetoableChangeListener) throws UnknownPropertyException, WrappedTargetException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Property[] getProperties() {
        int n = this.m_properties.size();
        Property[] propertyArray = new Property[n];
        for (int i = 0; i < n; ++i) {
            propertyArray[i] = this.m_properties.get(i).getProperty();
        }
        return propertyArray;
    }

    public Property getPropertyByName(String string) throws UnknownPropertyException {
        PropertyInfo propertyInfo = this.m_propertyMap.get(string);
        if (propertyInfo != null) {
            return propertyInfo.getProperty();
        }
        throw new UnknownPropertyException();
    }

    public boolean hasPropertyByName(String string) {
        return this.m_propertyMap.containsKey(string);
    }

    private void lockDocument(boolean bl) {
        if (bl) {
            this.m_xModel.lockControllers();
        } else {
            this.m_xModel.unlockControllers();
        }
        try {
            XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)this.m_document.getSheets());
            int n = xIndexAccess.getCount();
            for (int i = 0; i < n; ++i) {
                Object object = xIndexAccess.getByIndex(i);
                XTableChartsSupplier xTableChartsSupplier = (XTableChartsSupplier)UnoRuntime.queryInterface(XTableChartsSupplier.class, (Object)object);
                XIndexAccess xIndexAccess2 = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xTableChartsSupplier.getCharts());
                int n2 = xIndexAccess2.getCount();
                for (int j = 0; j < n2; ++j) {
                    Object object2 = xIndexAccess2.getByIndex(j);
                    XEmbeddedObjectSupplier xEmbeddedObjectSupplier = (XEmbeddedObjectSupplier)UnoRuntime.queryInterface(XEmbeddedObjectSupplier.class, (Object)object2);
                    XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xEmbeddedObjectSupplier.getEmbeddedObject());
                    if (bl) {
                        xModel.lockControllers();
                        continue;
                    }
                    xModel.unlockControllers();
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(BaseNLPSolver.class.getName()).log(Level.SEVERE, null, exception);
        }
    }

    protected void lockDocument() {
        this.lockDocument(true);
    }

    protected void unlockDocument() {
        this.lockDocument(false);
    }

    public static String nanoTimeToString(ResourceManager resourceManager, long l) {
        if (l < 0L) {
            return null;
        }
        if (l == 0L) {
            return "0";
        }
        if (l < 1000L) {
            return l + " " + resourceManager.getLocalizedString("Time.Nanoseconds", "Nanoseconds");
        }
        double d = (double)l / 1000.0;
        if (d < 1000.0) {
            return String.format("%.2f %s", d, resourceManager.getLocalizedString("Time.Microseconds", "Microseconds"));
        }
        double d2 = d / 1000.0;
        if (d2 < 1000.0) {
            return String.format("%.2f %s", d2, resourceManager.getLocalizedString("Time.Milliseconds", "Milliseconds"));
        }
        double d3 = d2 / 1000.0;
        if (d3 < 90.0) {
            return String.format("%.2f %s", d3, resourceManager.getLocalizedString("Time.Seconds", "Seconds"));
        }
        long l2 = (long)d3 / 60L;
        d3 -= (double)(l2 * 60L);
        long l3 = l2 / 60L;
        l2 -= l3 * 60L;
        long l4 = l3 / 24L;
        l3 -= l4 * 24L;
        if (l4 > 0L) {
            return String.format("%d %s, %d %s", l4, resourceManager.getLocalizedString(String.format("Time.Day%s", l4 == 1L ? "" : "s"), "Days"), l3, resourceManager.getLocalizedString(String.format("Time.Hour%s", l3 == 1L ? "" : "s"), "Hours"));
        }
        if (l3 > 0L) {
            return String.format("%d %s, %d %s", l3, resourceManager.getLocalizedString(String.format("Time.Hour%s", l3 == 1L ? "" : "s"), "Hours"), l2, resourceManager.getLocalizedString(String.format("Time.Minute%s", l2 == 1L ? "" : "s"), "Minutes"));
        }
        if (l2 > 0L) {
            return String.format("%d %s, %.0f %s", l2, resourceManager.getLocalizedString(String.format("Time.Minute%s", l2 == 1L ? "" : "s"), "Minutes"), Math.floor(d3), resourceManager.getLocalizedString(String.format("Time.Second%s", Math.floor(d3) == 1.0 ? "" : "s"), "Seconds"));
        }
        return String.format("%.2f %s", d3, resourceManager.getLocalizedString("Time.Seconds", "Seconds"));
    }

    protected static class CellMap {
        protected int Range;
        protected int Col;
        protected int Row;

        protected CellMap() {
        }
    }

    private static class RowInfo {
        private short Sheet;
        private int Row;
        private int StartCol;
        private int EndCol;

        private RowInfo(short s, int n) {
            this.Sheet = s;
            this.Row = n;
        }

        private CellRangeAddress getCellRangeAddress(int n) {
            CellRangeAddress cellRangeAddress = new CellRangeAddress();
            cellRangeAddress.Sheet = this.Sheet;
            cellRangeAddress.StartColumn = this.StartCol;
            cellRangeAddress.StartRow = this.Row;
            cellRangeAddress.EndColumn = this.EndCol;
            cellRangeAddress.EndRow = n;
            return cellRangeAddress;
        }
    }

    protected class ExtSolverConstraint {
        public XCell Left;
        public SolverConstraintOperator Operator;
        public XCell Right;
        public double Data;

        private ExtSolverConstraint(XCell xCell, SolverConstraintOperator solverConstraintOperator, Object object) {
            this.Left = xCell;
            this.Operator = solverConstraintOperator;
            this.Right = null;
            if (object instanceof Number) {
                this.Data = ((Number)object).doubleValue();
            } else if (object instanceof CellAddress) {
                XCell xCell2 = BaseNLPSolver.this.getCell((CellAddress)object);
                if (xCell2.getType() == CellContentType.VALUE) {
                    this.Data = xCell2.getValue();
                } else {
                    this.Right = xCell2;
                    this.Data = 0.0;
                }
            }
        }

        public double getLeftValue() {
            if (this.Right == null) {
                return this.Left.getValue();
            }
            return this.Left.getValue() - this.Right.getValue();
        }
    }
}

