/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.proxy;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import oracle.ucp.proxy.AnnotationsRegistry;
import oracle.ucp.proxy.ClassGenerator;
import oracle.ucp.proxy.GeneratedProxiesRegistry;
import oracle.ucp.proxy.ProxyFactory;

public class ProxyExport {
    public static void main(String[] args) throws ClassNotFoundException, IOException {
        if (args.length <= 4 || !"-p".equals(args[0]) || !"-d".equals(args[2])) {
            System.out.println("Usage:");
            System.out.println("java -classpath ojdbc6.jar oracle.ucp.proxy.ProxyExport -p <package> -d <dir> class1 class2 class3 ...");
            System.out.println("  package - package to define generated proxies in");
            System.out.println("  dir - directory to store exported proxy classes");
            System.out.println("  class1 class2 class3 ... - superclasses annotated with @ProxyFor annotation");
            return;
        }
        String proxyPackage = args[1];
        String dir = args[3];
        ArrayList clazzes = new ArrayList();
        for (int argsIndex = 4; argsIndex < args.length; ++argsIndex) {
            clazzes.add(Class.forName(args[argsIndex]));
        }
        ProxyFactory proxyFactory = ProxyFactory.createProxyFactory(proxyPackage, clazzes.toArray(new Class[0]));
        AnnotationsRegistry annotationsRegistry = proxyFactory.annotationsRegistry;
        for (AnnotationsRegistry.Value value : annotationsRegistry.values()) {
            Class<?> superclass = value.getSuperclass();
            for (Class<?> iface : value.getIfacesToProxy()) {
                GeneratedProxiesRegistry.Key key = new GeneratedProxiesRegistry.Key(proxyPackage, iface, superclass);
                byte[] bytecode = ClassGenerator.generateBytecode(proxyPackage, key, proxyFactory.annotationsRegistry);
                String pathname = key.makePathname();
                int dirEnd = pathname.lastIndexOf(File.separator);
                if (-1 != dirEnd) {
                    String subdir = pathname.substring(0, dirEnd);
                    new File(dir + File.separator + subdir).mkdirs();
                }
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dir + File.separator + pathname));
                out.write(bytecode);
                out.close();
            }
        }
    }
}

