/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import oracle.security.pki.JCEUtil;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIECPublicKey;
import oracle.security.pki.OraclePKIPrincipalImpl;
import oracle.security.pki.OraclePKIRSAPublicKey;
import oracle.security.pki.TransitionMode;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1OctetString;
import oracle.security.pki.internal.cert.GeneralName;
import oracle.security.pki.internal.cert.PKIX;
import oracle.security.pki.internal.cert.X509;
import oracle.security.pki.internal.cert.X509Extension;
import oracle.security.pki.internal.cert.X509ExtensionSet;
import oracle.security.pki.internal.cert.ext.BasicConstraintsExtension;
import oracle.security.pki.internal.cert.ext.KeyUsageExtension;
import oracle.security.pki.internal.cert.ext.SubjectAltNameExtension;
import oracle.security.pki.util.CryptoUtils;

public final class OraclePKIX509CertImpl
extends X509Certificate {
    private final X509 a;

    public OraclePKIX509CertImpl(X509 x509) {
        this.a = x509;
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (this.a.l().compareTo(date) < 0) {
            OraclePKIDebug.a("Certificate expired on " + this.a.l());
            throw new CertificateExpiredException();
        }
        if (this.a.k().compareTo(date) > 0) {
            OraclePKIDebug.a("Certificate not valid until " + this.a.k());
            throw new CertificateNotYetValidException();
        }
    }

    @Override
    public int getVersion() {
        try {
            CertificateFactory certificateFactory = JCEUtil.getCertificateFactoryInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.a.g()));
            return x509Certificate.getVersion();
        }
        catch (Throwable throwable) {
            OraclePKIDebug.a("Java can't parse this cert");
            return 0;
        }
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.a.o();
    }

    public String getHexSerialNumber() {
        return this.a(this.a.o().toByteArray());
    }

    @Override
    public Principal getIssuerDN() {
        return new OraclePKIPrincipalImpl(this.a.n());
    }

    @Override
    public Principal getSubjectDN() {
        return new OraclePKIPrincipalImpl(this.a.m());
    }

    @Override
    public Date getNotBefore() {
        return this.a.k();
    }

    @Override
    public Date getNotAfter() {
        return this.a.l();
    }

    @Override
    public byte[] getTBSCertificate() throws CertificateEncodingException {
        try {
            CertificateFactory certificateFactory = JCEUtil.getCertificateFactoryInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.a.g()));
            return x509Certificate.getTBSCertificate();
        }
        catch (Throwable throwable) {
            throw new CertificateEncodingException();
        }
    }

    @Override
    public byte[] getSignature() {
        try {
            return this.a.f();
        }
        catch (SignatureException signatureException) {
            return null;
        }
    }

    @Override
    public String getSigAlgName() {
        return this.a.t();
    }

    @Override
    public String getSigAlgOID() {
        return this.a.s().d();
    }

    @Override
    public byte[] getSigAlgParams() {
        try {
            CertificateFactory certificateFactory = JCEUtil.getCertificateFactoryInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.a.g()));
            return x509Certificate.getSigAlgParams();
        }
        catch (Throwable throwable) {
            OraclePKIDebug.a("Java can't parse this cert");
            return null;
        }
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        try {
            CertificateFactory certificateFactory = JCEUtil.getCertificateFactoryInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.a.g()));
            return x509Certificate.getIssuerUniqueID();
        }
        catch (Throwable throwable) {
            OraclePKIDebug.a("Java can't parse this cert");
            return null;
        }
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        try {
            CertificateFactory certificateFactory = JCEUtil.getCertificateFactoryInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.a.g()));
            return x509Certificate.getSubjectUniqueID();
        }
        catch (Throwable throwable) {
            OraclePKIDebug.a("Java can't parse this cert");
            return null;
        }
    }

    @Override
    public boolean[] getKeyUsage() {
        try {
            KeyUsageExtension keyUsageExtension = (KeyUsageExtension)this.a.a(PKIX.E);
            if (keyUsageExtension == null) {
                return null;
            }
            return new boolean[]{keyUsageExtension.a(0), keyUsageExtension.a(1), keyUsageExtension.a(2), keyUsageExtension.a(3), keyUsageExtension.a(4), keyUsageExtension.a(5), keyUsageExtension.a(6), keyUsageExtension.a(7), keyUsageExtension.a(8)};
        }
        catch (ClassCastException classCastException) {
            System.out.println("Error Msg in getKeyUsage()  is :  " + classCastException.getMessage());
            classCastException.printStackTrace();
            return null;
        }
    }

    @Override
    public int getBasicConstraints() {
        BasicConstraintsExtension basicConstraintsExtension = (BasicConstraintsExtension)this.a.a(PKIX.H);
        if (basicConstraintsExtension == null) {
            return -1;
        }
        if (!basicConstraintsExtension.e()) {
            return -1;
        }
        BigInteger bigInteger = basicConstraintsExtension.f();
        if (bigInteger == null) {
            return Integer.MAX_VALUE;
        }
        return bigInteger.intValue();
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        return this.a.g();
    }

    public String getMD5Digest() throws CertificateEncodingException {
        byte[] byArray;
        block2: {
            byte[] byArray2 = this.getEncoded();
            byArray = null;
            try {
                MessageDigest messageDigest = JCEUtil.getMessageDigestInstance("MD5");
                byArray = messageDigest.digest(byArray2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (!OraclePKIDebug.getDebugFlag()) break block2;
                noSuchAlgorithmException.printStackTrace();
            }
        }
        return this.a(byArray);
    }

    public String getSHADigest() throws CertificateEncodingException {
        byte[] byArray;
        block2: {
            byte[] byArray2 = this.getEncoded();
            byArray = null;
            try {
                MessageDigest messageDigest = JCEUtil.getMessageDigestInstance("SHA-1");
                byArray = messageDigest.digest(byArray2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (!OraclePKIDebug.getDebugFlag()) break block2;
                noSuchAlgorithmException.printStackTrace();
            }
        }
        return this.a(byArray);
    }

    public String getSHA256Digest() throws CertificateEncodingException {
        byte[] byArray;
        block2: {
            byte[] byArray2 = this.getEncoded();
            byArray = null;
            try {
                MessageDigest messageDigest = JCEUtil.getMessageDigestInstance("SHA-256");
                byArray = messageDigest.digest(byArray2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (!OraclePKIDebug.getDebugFlag()) break block2;
                noSuchAlgorithmException.printStackTrace();
            }
        }
        return this.a(byArray);
    }

    String a(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        byte by = 0;
        n = byArray.length * 2 + (byArray.length - 1);
        byte[] byArray2 = new byte[n];
        String string = "0123456789ABCDEF";
        byte[] byArray3 = string.getBytes();
        String string2 = ":";
        byte[] byArray4 = string2.getBytes();
        for (n2 = 0; n2 < n - 2; n2 += 3) {
            by = byArray[n2 / 3];
            byArray2[n2] = byArray3[(by & 0xF0) >> 4];
            byArray2[n2 + 1] = byArray3[by & 0xF];
            byArray2[n2 + 2] = byArray4[0];
        }
        by = byArray[n / 3];
        n2 = n - 2;
        byArray2[n2] = byArray3[(by & 0xF0) >> 4];
        byArray2[n2 + 1] = byArray3[by & 0xF];
        return new String(byArray2);
    }

    @Override
    public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        throw new CertificateException("Not implemented");
    }

    @Override
    public void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        throw new CertificateException("Not implemented");
    }

    @Override
    public String toString() {
        return this.a.toString();
    }

    public String customizedDisplayString() {
        Object object;
        String string = null;
        String string2 = "Version:              " + Integer.toString(this.getVersion()) + "\nSubject:              " + this.a.m() + "\nIssuer:               " + this.a.n() + "\nSerial Number:        " + this.getHexSerialNumber() + "\nNot Before:           " + this.a.D() + "\nNot After:            " + this.a.C() + "\nFingerprint:          " + this.a(this.a.r()) + "\nSignature Algorithm:  " + this.getSigAlgName();
        try {
            if (!TransitionMode.isFIPS140ModeEnabled()) {
                string = this.getMD5Digest();
                string2 = string2 + "\nMD5 digest:           " + string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string = this.getSHA256Digest();
            string2 = string2 + "\nSHA-256 digest:       " + string;
            string = this.getSHADigest();
            string2 = string2 + "\nSHA-1 digest:           " + string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        string2 = string2 + "\nSubject Public Key Information:";
        string2 = string2 + "\nKey Algorithm:        " + this.getPublicKey().getAlgorithm();
        string2 = string2 + "\nKey Length:           (" + CryptoUtils.getPublicKeyBitLength(this.getPublicKey()) + " bit)\n\tKey Data:           ";
        PublicKey publicKey = this.a.b();
        if (publicKey instanceof RSAKey) {
            Key key;
            object = "{ modulus = ";
            if (publicKey instanceof RSAPublicKey) {
                key = (RSAPublicKey)publicKey;
                object = (String)object + key.getModulus() + ", exponent = " + key.getPublicExponent();
            } else {
                key = (RSAPrivateCrtKey)((Object)publicKey);
                object = (String)object + key.getModulus() + ", exponent = " + key.getPrivateExponent();
            }
            string2 = string2 + (String)object + "}";
        }
        object = this.a.q();
        int n = 1;
        if (object != null && ((X509ExtensionSet)object).c() > 0) {
            string2 = string2 + "\nExtensions:";
            for (X509Extension x509Extension : ((X509ExtensionSet)object).b()) {
                string2 = string2 + "\n\t" + Integer.toString(n) + ". " + x509Extension;
                ++n;
            }
        }
        return string2;
    }

    @Override
    public PublicKey getPublicKey() {
        PublicKey publicKey = this.a.b();
        if (publicKey instanceof RSAPublicKey) {
            return new OraclePKIRSAPublicKey((RSAPublicKey)publicKey);
        }
        if (publicKey instanceof ECPublicKey) {
            return new OraclePKIECPublicKey((ECPublicKey)publicKey);
        }
        return null;
    }

    public int getPublicKeyLength() {
        PublicKey publicKey = this.a.b();
        if (publicKey instanceof RSAPublicKey || publicKey instanceof ECPublicKey) {
            return CryptoUtils.getPublicKeyBitLength(publicKey);
        }
        return 0;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return this.a.q().d();
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        try {
            CertificateFactory certificateFactory = JCEUtil.getCertificateFactoryInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.a.g()));
            return x509Certificate.getCriticalExtensionOIDs();
        }
        catch (Throwable throwable) {
            OraclePKIDebug.a("Java can't parse this cert");
            return null;
        }
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        try {
            CertificateFactory certificateFactory = JCEUtil.getCertificateFactoryInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.a.g()));
            return x509Certificate.getCriticalExtensionOIDs();
        }
        catch (Throwable throwable) {
            OraclePKIDebug.a("Java can't parse this cert");
            return null;
        }
    }

    @Override
    public byte[] getExtensionValue(String string) {
        X509Extension x509Extension = this.a.a(new ASN1ObjectID(string));
        if (x509Extension == null) {
            OraclePKIDebug.a("No Extension present");
            return null;
        }
        byte[] byArray = x509Extension.d();
        if (byArray != null && byArray.length > 0) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                ASN1OctetString.a(byteArrayOutputStream, byArray);
            }
            catch (IOException iOException) {
                OraclePKIDebug.a("Error in getting ASN output of Extension");
                return null;
            }
            return byteArrayOutputStream.toByteArray();
        }
        OraclePKIDebug.a("Error in getting byte array from  Extension");
        return null;
    }

    public X509 getX509() {
        return this.a;
    }

    public String getPublicKeyType() {
        PublicKey publicKey = this.a.b();
        if (publicKey instanceof RSAPublicKey) {
            return "RSA";
        }
        if (publicKey instanceof ECPublicKey) {
            return "EC";
        }
        return "";
    }

    @Override
    public Collection<List<?>> getSubjectAlternativeNames() {
        ArrayList arrayList = null;
        try {
            SubjectAltNameExtension subjectAltNameExtension = (SubjectAltNameExtension)this.a.a(PKIX.F);
            if (subjectAltNameExtension == null) {
                return null;
            }
            arrayList = new ArrayList();
            for (GeneralName generalName : subjectAltNameExtension.e()) {
                arrayList.add(generalName.c());
            }
        }
        catch (Throwable throwable) {
            OraclePKIDebug.a("Java can't parse this cert");
        }
        return arrayList;
    }

    public void printCertInfoForWallet() throws CertificateEncodingException {
        String string = this.getIssuerDN().toString();
        string = string.replaceAll("EmailAddress=", "EMAIL=");
        System.out.println("Issuer:         " + string);
        System.out.println("Not Before:     " + this.getNotBefore());
        System.out.println("Not After:      " + this.getNotAfter());
        System.out.println("Serial Number:  " + this.getHexSerialNumber());
        System.out.println("Key Length:     " + this.getPublicKeyLength());
        if (!TransitionMode.isFIPS140ModeEnabled()) {
            System.out.println("MD5 digest:     " + this.getMD5Digest());
        }
        System.out.println("SHA-256 digest: " + this.getSHA256Digest());
        System.out.println("SHA-1 digest:   " + this.getSHADigest());
        System.out.println();
    }
}

