/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.internal.OracleConnection;

final class T4CTTIk2rpc
extends T4CTTIfun {
    static final int K2RPClogon = 1;
    static final int K2RPCbegin = 2;
    static final int K2RPCend = 3;
    static final int K2RPCrecover = 4;
    static final int K2RPCsession = 5;
    private int k2rpctyp;
    private int command;

    T4CTTIk2rpc(T4CConnection _conn) {
        super(_conn, (byte)3);
        this.setFunCode((short)67);
    }

    void doOK2RPC(int _k2rpctyp, int _command) throws IOException, SQLException {
        this.k2rpctyp = _k2rpctyp;
        this.command = _command;
        this.doRPC();
    }

    @Override
    void marshal() throws IOException {
        this.meg.marshalUB4(0L);
        this.meg.marshalUB4(this.k2rpctyp);
        this.meg.marshalPTR();
        this.meg.marshalUB4(3L);
        this.meg.marshalNULLPTR();
        this.meg.marshalUB4(0L);
        this.meg.marshalNULLPTR();
        this.meg.marshalUB4(0L);
        this.meg.marshalPTR();
        this.meg.marshalUB4(3L);
        this.meg.marshalPTR();
        this.meg.marshalNULLPTR();
        this.meg.marshalUB4(0L);
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
        this.meg.marshalUB4(0L);
        this.meg.marshalNULLPTR();
        if (this.connection.getTTCVersion() >= 8) {
            this.meg.marshalPTR();
            this.meg.marshalUB4(2L);
            this.meg.marshalPTR();
            this.meg.marshalUB4(2L);
            this.meg.marshalPTR();
        }
        this.meg.marshalUB4(this.command);
        this.meg.marshalUB4(0L);
        this.meg.marshalUB4(0L);
        if (this.connection.getTTCVersion() >= 8) {
            this.meg.marshalUB4(0L);
            this.meg.marshalUB4(0L);
        }
    }

    @Override
    void readRPA() throws IOException, SQLException {
        int k2rpco4l = this.meg.unmarshalUB2();
        for (int i = 0; i < k2rpco4l; ++i) {
            this.meg.unmarshalUB4();
        }
        if (this.connection.getTTCVersion() >= 8) {
            int k2rpcoub4l = this.meg.unmarshalUB2();
            for (int i = 0; i < k2rpcoub4l; ++i) {
                this.meg.unmarshalUB4();
            }
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

