/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.PickleContext;
import oracle.sql.AttributeDescriptor;
import oracle.sql.TypeDescriptor;

class Kotad {
    static final int KOTADSIG = -1365573631;
    static final int KOTPDSIG = -1365442559;
    static final int KOTRDSIG = -1365377023;
    static final int KOTCDSIG = -1365311487;
    static final int KOTODSIG = -1365307391;
    static final int KOTADXSIG = -1365303295;
    static final int KOTADPRV = 1;
    static final int KOTADPUB = 2;
    static final int KOTADCNT = 4;
    static final int KOTADCFM = 248;
    static final int KOTADSUB = 256;
    static final int KOTADPTR = 16384;
    static final int KOTADREF = 32768;
    static final int KOTADCNN = 65536;
    static final int KOTADCFN = 131072;
    static final int KOTADCVN = 262144;
    static final int KOTADTRN = 512;
    static final int KOTADCPT = 4096;
    static final int KOTADIN = 256;
    static final int KOTADOUT = 512;
    static final int KOTADCBR = 1024;
    static final int KOTADREQ = 2048;
    static final int KOTADNCP = 0x100000;
    private int kotadkvn;
    private byte[] kotadnam;
    private byte[] kotadtrf;
    private short kotadtvn;
    private short kotadid;
    private byte[] kotadprf;
    private short kotadpvn;
    private int kotadflg;
    private long kotadpre;
    private int kotadcid;
    private byte kotadscl;
    private int kotadcne;
    private byte[] kotaddft;
    private long kotadtyp;
    private byte[] kotadadd;
    private static final String CLASS_NAME = Kotad.class.getName();

    private Kotad() throws SQLException {
    }

    private static Kotad unpickleKotad(PickleContext context) throws SQLException {
        Kotad kotad = new Kotad();
        context.skipBytes(2);
        long length = context.readLength(true) - 2;
        context.skipBytes(1);
        kotad.kotadkvn = (int)context.readUB4();
        kotad.kotadnam = context.readDataValue();
        kotad.kotadtrf = context.readDataValue();
        context.skipBytes(1);
        kotad.kotadtvn = (short)context.readUB2();
        context.skipBytes(1);
        kotad.kotadid = (short)context.readUB2();
        kotad.kotadprf = context.readDataValue();
        context.skipBytes(1);
        kotad.kotadpvn = (short)context.readUB2();
        context.skipBytes(1);
        kotad.kotadflg = (int)context.readUB4();
        context.skipBytes(1);
        kotad.kotadpre = context.readUB4();
        context.skipBytes(1);
        kotad.kotadcid = context.readUB2();
        context.skipBytes(1);
        kotad.kotadscl = context.readByte();
        context.skipBytes(1);
        kotad.kotadcne = (int)context.readUB4();
        kotad.kotaddft = context.readDataValue();
        context.skipBytes(1);
        kotad.kotadtyp = context.readUB4();
        kotad.kotadadd = context.readDataValue();
        return kotad;
    }

    static final TypeDescriptor unpickleTypeDescriptorImage(PickleContext context) throws SQLException {
        Kotad kotad = Kotad.unpickleKotad(context);
        if (kotad.kotadkvn != -1365311487) {
            SQLException sqlException = (SQLException)DatabaseError.createSqlException(179).fillInStackTrace();
            CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "unpickleTypeDescriptorImage", "Encountered a non-collection type description for what a predefined type : {0}", (String)null, sqlException, (Object)sqlException.getMessage());
            throw sqlException;
        }
        TypeDescriptor td = Kotad.constructPredefinedTypeDescriptor(kotad);
        return td;
    }

    static final AttributeDescriptor unpickleAttributeImage(boolean isPredefined, PickleContext context) throws SQLException {
        Kotad kotad = Kotad.unpickleKotad(context);
        if (kotad.kotadkvn != -1365573631) {
            SQLException sqlException = (SQLException)DatabaseError.createSqlException(179).fillInStackTrace();
            CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "unpickleAttributeImage", "The type isn't an attribute : {0}", (String)null, sqlException, (Object)sqlException.getMessage());
            throw sqlException;
        }
        TypeDescriptor td = null;
        if (isPredefined) {
            td = Kotad.constructPredefinedTypeDescriptor(kotad);
        }
        AttributeDescriptor ret = new AttributeDescriptor(new String(kotad.kotadnam), kotad.kotadid, kotad.kotadflg, td);
        return ret;
    }

    private static final TypeDescriptor constructPredefinedTypeDescriptor(Kotad kotad) throws SQLException {
        if (kotad.kotadtrf.length != 36) {
            SQLException sqlException = (SQLException)DatabaseError.createSqlException(180).fillInStackTrace();
            CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "constructPredefinedTypeDescriptor", "kotadtrf is malformed : {0}", (String)null, sqlException, (Object)sqlException.getMessage());
            throw sqlException;
        }
        for (int i = 4; i < 18; ++i) {
            if (kotad.kotadtrf[i] == 0) continue;
            SQLException sqlException = (SQLException)DatabaseError.createSqlException(180).fillInStackTrace();
            CommonDiagnosable.getInstance().debug(Level.INFO, SecurityLabel.UNKNOWN, "oracle/sql/Kotad", "constructPredefinedTypeDescriptor", "This CREF isn't for a predefined type : {0}", (String)null, sqlException, (Object)sqlException.getMessage());
            throw sqlException;
        }
        short rdbmsTypeCode = TypeDescriptor.OID_TO_TYPECODE[kotad.kotadtrf[19]];
        TypeDescriptor td = new TypeDescriptor(rdbmsTypeCode);
        td.setPrecision(kotad.kotadpre);
        td.setScale(kotad.kotadscl);
        return td;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

