/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.dom;

import oracle.xdb.dom.XDBDocument;
import oracle.xdb.dom.XDBNode;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;

public class XDBCharData
extends XDBNode
implements CharacterData {
    @Override
    public String getData() throws DOMException {
        return super.getNodeValue();
    }

    @Override
    public void setData(String data) throws DOMException {
        super.setNodeValue(data);
    }

    @Override
    public int getLength() throws DOMException {
        String data = super.getNodeValue();
        if (data != null) {
            return data.length();
        }
        return 0;
    }

    @Override
    public String substringData(int offset, int count) throws DOMException {
        String data = super.getNodeValue();
        try {
            if (data != null) {
                int end_offset = offset + count;
                int len = data.length();
                if (end_offset >= len) {
                    end_offset = len;
                }
                return data.substring(offset, end_offset);
            }
            return null;
        }
        catch (Exception ex) {
            throw new DOMException(1, ex.getMessage());
        }
    }

    @Override
    public void appendData(String appstring) throws DOMException {
        String data = super.getNodeValue();
        if (data != null) {
            super.setNodeValue(data + appstring);
        } else {
            super.setNodeValue(appstring);
        }
    }

    @Override
    public void insertData(int offset, String appstring) throws DOMException {
        String data = super.getNodeValue();
        if (data != null) {
            StringBuffer buf = new StringBuffer(data);
            try {
                buf.insert(offset, appstring);
            }
            catch (Exception ex) {
                throw new DOMException(1, ex.getMessage());
            }
            super.setNodeValue(buf.toString());
        } else {
            super.setNodeValue(appstring);
        }
    }

    @Override
    public void deleteData(int offset, int count) throws DOMException {
        String data = super.getNodeValue();
        if (data != null) {
            StringBuffer buf = new StringBuffer(data);
            try {
                buf.delete(offset, offset + count);
            }
            catch (Exception ex) {
                throw new DOMException(1, ex.getMessage());
            }
            super.setNodeValue(buf.toString());
        } else {
            super.setNodeValue(data);
        }
    }

    @Override
    public void replaceData(int offset, int count, String repdata) throws DOMException {
        String data = super.getNodeValue();
        if (data != null) {
            StringBuffer buf = new StringBuffer(data);
            try {
                buf.replace(offset, offset + count, repdata);
            }
            catch (Exception ex) {
                throw new DOMException(1, ex.getMessage());
            }
            super.setNodeValue(buf.toString());
        } else {
            super.setNodeValue(data);
        }
    }

    XDBCharData(XDBDocument doc, long xob, short type) {
        super(doc, xob, type);
    }

    XDBCharData(XDBDocument doc, long xob) {
        super(doc, xob);
    }
}

