/*
 * Decompiled with CFR 0.152.
 */
package com.github.jgonian.ipmath;

import com.github.jgonian.ipmath.Range;
import com.github.jgonian.ipmath.Rangeable;
import com.github.jgonian.ipmath.StartAndSizeComparator;
import com.github.jgonian.ipmath.Validate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;

public class SortedRangeSet<C extends Rangeable<C, R>, R extends Range<C, R>>
implements Iterable<R> {
    private final NavigableSet<R> set = new TreeSet(StartAndSizeComparator.get());

    public void addAll(SortedRangeSet<C, R> ranges) {
        for (Range range : ranges) {
            this.add(range);
        }
    }

    public void addAll(Collection<R> ranges) {
        for (Range range : ranges) {
            this.add(range);
        }
    }

    public void add(R range) {
        if (this.contains(range)) {
            return;
        }
        this.freeAndMergeConsecutive(range);
    }

    private void freeAndMergeConsecutive(R range) {
        Range merged;
        Range rightSide = (Range)this.set.higher(range);
        Range leftSide = (Range)this.set.lower(range);
        if (!range.overlaps((Range)rightSide) && !range.overlaps((Range)leftSide)) {
            this.set.add(range);
        }
        if (range.overlaps((Range)rightSide) || range.isConsecutive((Range)rightSide)) {
            merged = range.merge((Range)rightSide);
            this.remove(rightSide);
            this.freeAndMergeConsecutive(merged);
        }
        if (range.overlaps((Range)leftSide) || range.isConsecutive((Range)leftSide)) {
            merged = range.merge((Range)leftSide);
            this.remove(leftSide);
            this.freeAndMergeConsecutive(merged);
        }
    }

    public void removeAll(SortedRangeSet<C, R> ranges) {
        for (Range range : ranges) {
            this.remove(range);
        }
    }

    public void removeAll(Collection<R> ranges) {
        for (Range range : ranges) {
            this.remove(range);
        }
    }

    public boolean remove(R range) {
        Range leftSide = (Range)this.set.floor(range);
        Range rightSide = (Range)this.set.ceiling(range);
        boolean removed = false;
        while (range.contains((Range)rightSide)) {
            this.set.remove(rightSide);
            removed = true;
            rightSide = this.set.higher(rightSide);
        }
        LinkedList<R> remainders = new LinkedList<R>();
        if (leftSide != null && leftSide.overlaps(range)) {
            this.set.remove(leftSide);
            remainders.addAll(leftSide.exclude(range));
            removed = true;
        }
        if (rightSide != null && rightSide.overlaps(range)) {
            this.set.remove(rightSide);
            remainders.addAll(rightSide.exclude(range));
            removed = true;
        }
        this.set.addAll(remainders);
        return removed;
    }

    public SortedRangeSet<C, R> intersection(SortedRangeSet<C, R> other) {
        SortedRangeSet<C, Range> result = new SortedRangeSet<C, Range>();
        for (Range thisRange : this.set) {
            Range leftSide = other.set.floor(thisRange);
            Range rightSide = other.set.ceiling(thisRange);
            if (thisRange.overlaps(leftSide)) {
                result.add(thisRange.intersection(leftSide));
            }
            if (!thisRange.overlaps(rightSide)) continue;
            result.add(thisRange.intersection(rightSide));
        }
        return result;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SortedRangeSet)) {
            return false;
        }
        SortedRangeSet that = (SortedRangeSet)o;
        return this.set.equals(that.set);
    }

    public final int hashCode() {
        return this.set.hashCode();
    }

    public boolean contains(R range) {
        Range leftmost = (Range)this.set.floor(range);
        Range rightmost = (Range)this.set.ceiling(range);
        return leftmost != null && leftmost.contains(range) || rightmost != null && rightmost.contains(range);
    }

    public void clear() {
        this.set.clear();
    }

    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public int size() {
        return this.set.size();
    }

    public Set<R> unmodifiableSet() {
        return Collections.unmodifiableSet(this.set);
    }

    public Set<R> modifiableSet() {
        TreeSet<R> copy = new TreeSet<R>(this.set.comparator());
        copy.addAll(this.set);
        return copy;
    }

    public R getSingleRange() {
        Validate.isTrue(this.set.size() == 1, "Expected exactly one range");
        return (R)((Range)this.set.first());
    }

    public R floor(R range) {
        return (R)((Range)this.set.floor(range));
    }

    public R ceiling(R range) {
        return (R)((Range)this.set.ceiling(range));
    }

    @Override
    public Iterator<R> iterator() {
        return this.set.iterator();
    }

    public String toString() {
        return this.set.toString();
    }
}

