/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import org.directwebremoting.extend.NamedConverter;
import org.directwebremoting.servlet.AmdModule;
import org.directwebremoting.servlet.BaseDtoHandler;
import org.directwebremoting.util.LocalUtil;

public class AmdDtoHandler
extends BaseDtoHandler {
    protected String amdDtoHandlerUrl;
    protected String amdDwrBaseModulePath;
    protected String amdDtoBaseModulePath;

    @Override
    protected String getBaseDtoPath() {
        return this.amdDtoHandlerUrl;
    }

    @Override
    public String generateDtoScript(String contextPath, String servletPath, String jsClassName) {
        String script = null;
        String dtojs = this.remoter.generateDtoJavaScript(jsClassName, "  ", "c");
        if (dtojs != null) {
            NamedConverter namedConv = this.converterManager.getNamedConverter(jsClassName);
            String jsSuperClassName = namedConv.getJavascriptSuperClass();
            AmdModule mod = new AmdModule(contextPath, servletPath);
            mod.addDependency(this.amdDwrBaseModulePath, "engine", "dwr");
            if (LocalUtil.hasLength(jsSuperClassName)) {
                mod.addDependency(this.amdDtoBaseModulePath, jsSuperClassName, "parent");
            }
            mod.addContent("  var c;\n");
            mod.addContent("\n");
            mod.addContent(dtojs);
            mod.addContent("    dwr.engine._mappedClasses[\"" + jsClassName + "\"] = c;\n");
            if (LocalUtil.hasLength(jsSuperClassName)) {
                String classExpression = "dwr.engine._mappedClasses[\"" + jsClassName + "\"]";
                mod.addContent(this.remoter.generateDtoInheritanceJavaScript("    ", classExpression, "parent", "dwr.engine._delegate"));
            }
            mod.addContent("\n");
            mod.addContent("  return c;\n");
            script = mod.toString();
        }
        return script;
    }

    public void setAmdDtoHandlerUrl(String amdDtoHandlerUrl) {
        this.amdDtoHandlerUrl = amdDtoHandlerUrl;
    }

    public void setAmdDwrBaseModulePath(String modulePath) {
        this.amdDwrBaseModulePath = modulePath;
    }

    public void setAmdDtoBaseModulePath(String modulePath) {
        this.amdDtoBaseModulePath = modulePath;
    }
}

