/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.kafka.common.security.oauthbearer.JwtRetrieverException;
import org.apache.kafka.common.utils.Utils;

public class JwtResponseParser {
    private static final String[] JSON_PATHS = new String[]{"/access_token", "/id_token"};
    private static final int MAX_RESPONSE_BODY_LENGTH = 1000;

    public String parseJwt(String responseBody) throws JwtRetrieverException {
        JsonNode rootNode;
        ObjectMapper mapper = new ObjectMapper();
        try {
            rootNode = mapper.readTree(responseBody);
        }
        catch (IOException e) {
            throw new JwtRetrieverException(e);
        }
        for (String jsonPath : JSON_PATHS) {
            String value;
            JsonNode node = rootNode.at(jsonPath);
            if (node == null || node.isMissingNode() || Utils.isBlank(value = node.textValue())) continue;
            return value.trim();
        }
        String snippet = responseBody;
        if (snippet.length() > 1000) {
            int actualLength = responseBody.length();
            String s = responseBody.substring(0, 1000);
            snippet = String.format("%s (trimmed to first %d characters out of %d total)", s, 1000, actualLength);
        }
        throw new JwtRetrieverException(String.format("The token endpoint response did not contain a valid JWT. Response: (%s)", snippet));
    }
}

