/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.ISourceFileReader;
import net.sourceforge.plantuml.SourceFileReaderAbstract;
import net.sourceforge.plantuml.file.SuggestedFile;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.security.SFile;

public class SourceFileReaderHardFile
extends SourceFileReaderAbstract
implements ISourceFileReader {
    private final File outputFile;

    private SourceFileReaderHardFile(Defines defines, File file, File outputFile, List<String> config, String charset, FileFormatOption fileFormatOption) throws IOException {
        super(file, fileFormatOption, defines, config, charset);
        this.outputFile = outputFile;
        FileSystem.getInstance().setCurrentDir(SFile.fromFile(file.getAbsoluteFile().getParentFile()));
    }

    @Override
    protected SuggestedFile getSuggestedFile(BlockUml blockUml) {
        SuggestedFile suggested = SuggestedFile.fromOutputFile(this.outputFile, this.getFileFormatOption().getFileFormat());
        return suggested;
    }
}

