// Copyright (C) 2023 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR BSD-3-Clause

import QtQuick
import QtQuick.Studio.Components

Item {
    id: iconsSkylight
    width: 48
    height: 48
    state: "state_icon_SkyMidday"

    SvgPathItem {
        x: 7
        y: 7
        width: 35
        height: 35
        visible: false
        antialiasing: true
        strokeWidth: 1.33333
        strokeColor: "transparent"
        fillColor: "#ffffff"
        path: "M 5.106040954589844 7.854960918426514 C 4.3466808795928955 7.069640934467316 4.346680760383606 5.8390408754348755 5.132447242736816 5.079640865325928 C 5.891807317733765 4.320280909538269 7.148367643356323 4.3202807903289795 7.9077677726745605 5.1060471534729 L 10.002448081970215 7.226686954498291 C 10.761808156967163 7.98604691028595 10.761808276176453 9.242607474327087 9.976041793823242 10.002007484436035 C 9.216681718826294 10.761367440223694 7.9601218700408936 10.734966576099396 7.200721740722656 9.975600242614746 L 5.106040954589844 7.854960918426514 Z M 4.9748406410217285 15.342960357666016 C 6.074520707130432 15.342960357666016 6.938600540161133 16.207040786743164 6.938600540161133 17.306720733642578 C 6.938600540161133 18.380000710487366 6.074520707130432 19.270483016967773 4.9748406410217285 19.270483016967773 L 1.963760495185852 19.270483016967773 C 0.8904803991317749 19.270483016967773 0 18.380000710487366 0 17.306720733642578 C 0 16.207040786743164 0.8904803991317749 15.342960357666016 1.963760495185852 15.342960357666016 L 4.9748406410217285 15.342960357666016 Z M 7.200040817260742 24.742563247680664 C 7.959400773048401 23.957243263721466 9.215959906578064 23.957240521907806 9.975359916687012 24.716154098510742 C 10.76067990064621 25.4755140542984 10.76067978143692 26.732076048851013 10.001766204833984 27.49147605895996 L 7.907086372375488 29.61211585998535 C 7.14772641658783 30.39743584394455 5.891166806221008 30.397434771060944 5.1317667961120605 29.638521194458008 C 4.3464468121528625 28.87916123867035 4.346446931362152 27.622603058815002 5.105360507965088 26.863203048706055 L 7.200040817260742 24.742563247680664 Z M 19.374839782714844 29.79536247253418 L 19.374839782714844 32.75412368774414 C 19.374839782714844 33.82740378379822 18.510759353637695 34.7178840637207 17.41107940673828 34.7178840637207 C 16.337799429893494 34.7178840637207 15.447319030761719 33.82740378379822 15.447319030761719 32.75412368774414 L 15.447319030761719 29.79536247253418 C 15.447319030761719 28.695682406425476 16.337799429893494 27.831602096557617 17.41107940673828 27.831602096557617 C 18.510759353637695 27.83175833657151 19.374839782714844 28.695682406425476 19.374839782714844 29.79536247253418 Z M 24.8204402923584 27.49135971069336 C 24.06108021736145 26.731999695301056 24.061081051826477 25.475439727306366 24.846847534179688 24.716039657592773 C 25.606207609176636 23.95667964220047 26.862767457962036 23.956680476665497 27.622167587280273 24.742446899414062 L 29.716848373413086 26.863086700439453 C 30.476208448410034 27.622446715831757 30.476207613945007 28.879006683826447 29.690441131591797 29.63840675354004 C 28.93108105659485 30.397766768932343 27.67452120780945 30.397765934467316 26.91512107849121 29.61199951171875 L 24.8204402923584 27.49135971069336 Z M 32.85844421386719 15.44736099243164 C 33.931724190711975 15.44736099243164 34.82220458984375 16.337841272354126 34.82220458984375 17.411121368408203 C 34.82220458984375 18.510801434516907 33.931724190711975 19.374879837036133 32.85844421386719 19.374879837036133 L 29.84736442565918 19.374879837036133 C 28.747684478759766 19.374879837036133 27.883604049682617 18.510801434516907 27.883604049682617 17.411121368408203 C 27.883604049682617 16.337841272354126 28.747684478759766 15.44736099243164 29.84736442565918 15.44736099243164 L 32.85844421386719 15.44736099243164 Z M 29.716440200805664 7.8549604415893555 L 27.62175941467285 9.97559928894043 C 26.862399399280548 10.734959244728088 25.605839431285858 10.760921061038971 24.846439361572266 10.002007484436035 C 24.061119318008423 9.242647528648376 24.06112039089203 7.986086487770081 24.82003402709961 7.226686477661133 L 26.91471290588379 5.106046676635742 C 27.674072921276093 4.320726692676544 28.930632889270782 4.320726811885834 29.690032958984375 5.0796403884887695 C 30.47583305835724 5.839000344276428 30.475833892822266 7.069800496101379 29.716440200805664 7.8549604415893555 Z M 22.621641159057617 17.35896110534668 C 22.621641159057617 14.478960990905762 20.291159629821777 12.148560523986816 17.411239624023438 12.148560523986816 C 14.531319618225098 12.148560523986816 12.20083999633789 14.47904086112976 12.20083999633789 17.35896110534668 C 12.20083999633789 20.2388813495636 14.531319618225098 22.56936264038086 17.411239624023438 22.56936264038086 C 20.291159629821777 22.56936264038086 22.621641159057617 20.2388813495636 22.621641159057617 17.35896110534668 Z M 26.548521041870117 17.35896110534668 C 26.548521041870117 22.41176128387451 22.464121341705322 26.49616050720215 17.41132164001465 26.49616050720215 C 12.358521938323975 26.49616050720215 8.274120330810547 22.41176128387451 8.274120330810547 17.35896110534668 C 8.274120330810547 12.306160926818848 12.358521938323975 8.221760749816895 17.41132164001465 8.221760749816895 C 22.464121341705322 8.221760749816895 26.548521041870117 12.306160926818848 26.548521041870117 17.35896110534668 Z M 19.374839782714844 1.9637597799301147 L 19.374839782714844 4.922519207000732 C 19.374839782714844 6.0221991539001465 18.48435938358307 6.886280536651611 17.41107940673828 6.886280536651611 C 16.311399459838867 6.886280536651611 15.447319030761719 6.0221991539001465 15.447319030761719 4.922519207000732 L 15.447319030761719 1.9637597799301147 C 15.447319030761719 0.8904798030853271 16.311399459838867 0 17.41107940673828 0 C 18.48435938358307 0 19.374839782714844 0.8904798030853271 19.374839782714844 1.9637597799301147 Z"
    }

    Image {
        id: icon_Colorful
        visible: false
        source: "file:content/images/Icons/Icon_Colorful.png"
        fillMode: Image.PreserveAspectFit
    }

    Image {
        id: icon_Dark
        visible: false
        source: "file:content/images/Icons/Icon_Dark.png"
        fillMode: Image.PreserveAspectFit
    }

    Image {
        id: icon_Light
        visible: false
        source: "file:content/images/Icons/Icon_Light.png"
        fillMode: Image.PreserveAspectFit
    }
    states: [
        State {
            name: "state_icon_SkyMidday"
            PropertyChanges {
                target: icon_Dark
                visible: true
            }
        },
        State {
            name: "state_icon_SkySunset"
            PropertyChanges {
                target: icon_Colorful
                visible: true
            }
        },
        State {
            name: "state_icon_SkySunrise"

            PropertyChanges {
                target: icon_Light
                visible: true
            }
        }
    ]
}

/*##^##
Designer {
    D{i:0;uuid:"b5674341-5d32-596d-ab2f-731adefeb8f6"}D{i:1;uuid:"126fd8d6-aff0-5cbf-9cd3-3627e8bc2a73"}
}
##^##*/

