/// \file
/// \ingroup tutorial_graphics
/// \notebook
/// \preview This macro draw all possible symbols provided by TMathtext.
/// \macro_image
/// \author Olivier Couet

TCanvas *tmathtext2()
{
   TCanvas *c1 = new TCanvas("mathtext", "TMathText symbol", 1200, 1400);

   TMathText l;
   l.SetTextSize(0.013);
   l.SetTextFont(132);

   // Draw 1st Column
   l.SetTextAlign(12);
   float y, step, x1, x2;
   y = 0.99;
   step = 0.0126;
   x1 = 0.01;
   x2 = x1 + 0.02;
   l.DrawMathText(x1, y, "\\\"");
   l.DrawText(x2, y, "\\\"");
   y -= step;
   l.DrawMathText(x1, y, "\\'");
   l.DrawText(x2, y, "\\'");
   y -= step;
   l.DrawMathText(x1, y, "\\.");
   l.DrawText(x2, y, "\\.");
   y -= step;
   l.DrawMathText(x1, y, "\\=");
   l.DrawText(x2, y, "\\=");
   y -= step;
   l.DrawMathText(x1, y, "\\Box");
   l.DrawText(x2, y, "\\Box");
   y -= step;
   l.DrawMathText(x1, y, "\\Bumpeq");
   l.DrawText(x2, y, "\\Bumpeq");
   y -= step;
   l.DrawMathText(x1, y, "\\Cap");
   l.DrawText(x2, y, "\\Cap");
   y -= step;
   l.DrawMathText(x1, y, "\\Cup");
   l.DrawText(x2, y, "\\Cup");
   y -= step;
   l.DrawMathText(x1, y, "\\Delta");
   l.DrawText(x2, y, "\\Delta");
   y -= step;
   l.DrawMathText(x1, y, "\\Diamond");
   l.DrawText(x2, y, "\\Diamond");
   y -= step;
   l.DrawMathText(x1, y, "\\Digamma");
   l.DrawText(x2, y, "\\Digamma");
   y -= step;
   l.DrawMathText(x1, y, "\\Doteq");
   l.DrawText(x2, y, "\\Doteq");
   y -= step;
   l.DrawMathText(x1, y, "\\Downarrow");
   l.DrawText(x2, y, "\\Downarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\Finv");
   l.DrawText(x2, y, "\\Finv");
   y -= step;
   l.DrawMathText(x1, y, "\\Game");
   l.DrawText(x2, y, "\\Game");
   y -= step;
   l.DrawMathText(x1, y, "\\Gamma");
   l.DrawText(x2, y, "\\Gamma");
   y -= step;
   l.DrawMathText(x1, y, "\\Im");
   l.DrawText(x2, y, "\\Im");
   y -= step;
   l.DrawMathText(x1, y, "\\Koppa");
   l.DrawText(x2, y, "\\Koppa");
   y -= step;
   l.DrawMathText(x1, y, "\\Lambda");
   l.DrawText(x2, y, "\\Lambda");
   y -= step;
   l.DrawMathText(x1, y, "\\Leftarrow");
   l.DrawText(x2, y, "\\Leftarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\Leftrightarrow");
   l.DrawText(x2, y, "\\Leftrightarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\Lleftarrow");
   l.DrawText(x2, y, "\\Lleftarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\Longleftarrow");
   l.DrawText(x2, y, "\\Longleftarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\Longleftrightarrow");
   l.DrawText(x2, y, "\\Longleftrightarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\Longrightarrow");
   l.DrawText(x2, y, "\\Longrightarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\Lsh");
   l.DrawText(x2, y, "\\Lsh");
   y -= step;
   l.DrawMathText(x1, y, "\\Omega");
   l.DrawText(x2, y, "\\Omega");
   y -= step;
   l.DrawMathText(x1, y, "\\P");
   l.DrawText(x2, y, "\\P");
   y -= step;
   l.DrawMathText(x1, y, "\\Phi");
   l.DrawText(x2, y, "\\Phi");
   y -= step;
   l.DrawMathText(x1, y, "\\Pi");
   l.DrawText(x2, y, "\\Pi");
   y -= step;
   l.DrawMathText(x1, y, "\\Psi");
   l.DrawText(x2, y, "\\Psi");
   y -= step;
   l.DrawMathText(x1, y, "\\Re");
   l.DrawText(x2, y, "\\Re");
   y -= step;
   l.DrawMathText(x1, y, "\\Rightarrow");
   l.DrawText(x2, y, "\\Rightarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\Rrightarrow");
   l.DrawText(x2, y, "\\Rrightarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\Rsh");
   l.DrawText(x2, y, "\\Rsh");
   y -= step;
   l.DrawMathText(x1, y, "\\S");
   l.DrawText(x2, y, "\\S");
   y -= step;
   l.DrawMathText(x1, y, "\\Sampi");
   l.DrawText(x2, y, "\\Sampi");
   y -= step;
   l.DrawMathText(x1, y, "\\San");
   l.DrawText(x2, y, "\\San");
   y -= step;
   l.DrawMathText(x1, y, "\\Sho");
   l.DrawText(x2, y, "\\Sho");
   y -= step;
   l.DrawMathText(x1, y, "\\Sigma");
   l.DrawText(x2, y, "\\Sigma");
   y -= step;
   l.DrawMathText(x1, y, "\\Stigma");
   l.DrawText(x2, y, "\\Stigma");
   y -= step;
   l.DrawMathText(x1, y, "\\Subset");
   l.DrawText(x2, y, "\\Subset");
   y -= step;
   l.DrawMathText(x1, y, "\\Supset");
   l.DrawText(x2, y, "\\Supset");
   y -= step;
   l.DrawMathText(x1, y, "\\Theta");
   l.DrawText(x2, y, "\\Theta");
   y -= step;
   l.DrawMathText(x1, y, "\\Uparrow");
   l.DrawText(x2, y, "\\Uparrow");
   y -= step;
   l.DrawMathText(x1, y, "\\Updownarrow");
   l.DrawText(x2, y, "\\Updownarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\Upsilon");
   l.DrawText(x2, y, "\\Upsilon");
   y -= step;
   l.DrawMathText(x1, y, "\\VarKoppa");
   l.DrawText(x2, y, "\\VarKoppa");
   y -= step;
   l.DrawMathText(x1, y, "\\Vdash");
   l.DrawText(x2, y, "\\Vdash");
   y -= step;
   l.DrawMathText(x1, y, "\\Vert");
   l.DrawText(x2, y, "\\Vert");
   y -= step;
   l.DrawMathText(x1, y, "\\Vvdash");
   l.DrawText(x2, y, "\\Vvdash");
   y -= step;
   l.DrawMathText(x1, y, "\\Xi");
   l.DrawText(x2, y, "\\Xi");
   y -= step;
   l.DrawMathText(x1, y, "\\^");
   l.DrawText(x2, y, "\\^");
   y -= step;
   l.DrawMathText(x1, y, "\\`");
   l.DrawText(x2, y, "\\`");
   y -= step;
   l.DrawMathText(x1, y, "\\aa");
   l.DrawText(x2, y, "\\aa");
   y -= step;
   l.DrawMathText(x1, y, "\\aleph");
   l.DrawText(x2, y, "\\aleph");
   y -= step;
   l.DrawMathText(x1, y, "\\alpha");
   l.DrawText(x2, y, "\\alpha");
   y -= step;
   l.DrawMathText(x1, y, "\\angle");
   l.DrawText(x2, y, "\\angle");
   y -= step;
   l.DrawMathText(x1, y, "\\approx");
   l.DrawText(x2, y, "\\approx");
   y -= step;
   l.DrawMathText(x1, y, "\\approxeq");
   l.DrawText(x2, y, "\\approxeq");
   y -= step;
   l.DrawMathText(x1, y, "\\asymp");
   l.DrawText(x2, y, "\\asymp");
   y -= step;
   l.DrawMathText(x1, y, "\\backepsilon");
   l.DrawText(x2, y, "\\backepsilon");
   y -= step;
   l.DrawMathText(x1, y, "\\backprime");
   l.DrawText(x2, y, "\\backprime");
   y -= step;
   l.DrawMathText(x1, y, "\\backsim");
   l.DrawText(x2, y, "\\backsim");
   y -= step;
   l.DrawMathText(x1, y, "\\backsimeq");
   l.DrawText(x2, y, "\\backsimeq");
   y -= step;
   l.DrawMathText(x1, y, "\\backslash");
   l.DrawText(x2, y, "\\backslash");
   y -= step;
   l.DrawMathText(x1, y, "\\barwedge");
   l.DrawText(x2, y, "\\barwedge");
   y -= step;
   l.DrawMathText(x1, y, "\\because");
   l.DrawText(x2, y, "\\because");
   y -= step;
   l.DrawMathText(x1, y, "\\beta");
   l.DrawText(x2, y, "\\beta");
   y -= step;
   l.DrawMathText(x1, y, "\\beth");
   l.DrawText(x2, y, "\\beth");
   y -= step;
   l.DrawMathText(x1, y, "\\between");
   l.DrawText(x2, y, "\\between");
   y -= step;
   l.DrawMathText(x1, y, "\\bigcirc");
   l.DrawText(x2, y, "\\bigcirc");
   y -= step;
   l.DrawMathText(x1, y, "\\bigstar");
   l.DrawText(x2, y, "\\bigstar");
   y -= step;
   l.DrawMathText(x1, y, "\\bigtriangledown");
   l.DrawText(x2, y, "\\bigtriangledown");
   y -= step;
   l.DrawMathText(x1, y, "\\bigtriangleup");
   l.DrawText(x2, y, "\\bigtriangleup");
   y -= step;
   l.DrawMathText(x1, y, "\\blacklozenge");
   l.DrawText(x2, y, "\\blacklozenge");
   y -= step;
   l.DrawMathText(x1, y, "\\blacksquare");
   l.DrawText(x2, y, "\\blacksquare");
   y -= step;
   l.DrawMathText(x1, y, "\\blacktriangle");
   l.DrawText(x2, y, "\\blacktriangle");
   y -= step;
   l.DrawMathText(x1, y, "\\blacktriangledown");
   l.DrawText(x2, y, "\\blacktriangledown");

   // Draw 2nd Column
   y = 0.99;
   step = 0.0126;
   x1 = 0.14;
   x2 = x1 + 0.02;
   l.DrawMathText(x1, y, "\\blacktriangleleft");
   l.DrawText(x2, y, "\\blacktriangleleft");
   y -= step;
   l.DrawMathText(x1, y, "\\blacktriangleright");
   l.DrawText(x2, y, "\\blacktriangleright");
   y -= step;
   l.DrawMathText(x1, y, "\\bowtie");
   l.DrawText(x2, y, "\\bowtie");
   y -= step;
   l.DrawMathText(x1, y, "\\boxdot");
   l.DrawText(x2, y, "\\boxdot");
   y -= step;
   l.DrawMathText(x1, y, "\\boxminus");
   l.DrawText(x2, y, "\\boxminus");
   y -= step;
   l.DrawMathText(x1, y, "\\boxplus");
   l.DrawText(x2, y, "\\boxplus");
   y -= step;
   l.DrawMathText(x1, y, "\\boxtimes");
   l.DrawText(x2, y, "\\boxtimes");
   y -= step;
   l.DrawMathText(x1, y, "\\bullet");
   l.DrawText(x2, y, "\\bullet");
   y -= step;
   l.DrawMathText(x1, y, "\\bulletdashcirc");
   l.DrawText(x2, y, "\\bulletdashcirc");
   y -= step;
   l.DrawMathText(x1, y, "\\bumpeq");
   l.DrawText(x2, y, "\\bumpeq");
   y -= step;
   l.DrawMathText(x1, y, "\\cap");
   l.DrawText(x2, y, "\\cap");
   y -= step;
   l.DrawMathText(x1, y, "\\cdot");
   l.DrawText(x2, y, "\\cdot");
   y -= step;
   l.DrawMathText(x1, y, "\\cdots");
   l.DrawText(x2, y, "\\cdots");
   y -= step;
   l.DrawMathText(x1, y, "\\centerdot");
   l.DrawText(x2, y, "\\centerdot");
   y -= step;
   l.DrawMathText(x1, y, "\\checkmark");
   l.DrawText(x2, y, "\\checkmark");
   y -= step;
   l.DrawMathText(x1, y, "\\chi");
   l.DrawText(x2, y, "\\chi");
   y -= step;
   l.DrawMathText(x1, y, "\\circ");
   l.DrawText(x2, y, "\\circ");
   y -= step;
   l.DrawMathText(x1, y, "\\circdashbullet");
   l.DrawText(x2, y, "\\circdashbullet");
   y -= step;
   l.DrawMathText(x1, y, "\\circeq");
   l.DrawText(x2, y, "\\circeq");
   y -= step;
   l.DrawMathText(x1, y, "\\circlearrowleft");
   l.DrawText(x2, y, "\\circlearrowleft");
   y -= step;
   l.DrawMathText(x1, y, "\\circlearrowright");
   l.DrawText(x2, y, "\\circlearrowright");
   y -= step;
   l.DrawMathText(x1, y, "\\circledR");
   l.DrawText(x2, y, "\\circledR");
   y -= step;
   l.DrawMathText(x1, y, "\\circledS");
   l.DrawText(x2, y, "\\circledS");
   y -= step;
   l.DrawMathText(x1, y, "\\circledast");
   l.DrawText(x2, y, "\\circledast");
   y -= step;
   l.DrawMathText(x1, y, "\\circledcirc");
   l.DrawText(x2, y, "\\circledcirc");
   y -= step;
   l.DrawMathText(x1, y, "\\circleddash");
   l.DrawText(x2, y, "\\circleddash");
   y -= step;
   l.DrawMathText(x1, y, "\\clubsuit");
   l.DrawText(x2, y, "\\clubsuit");
   y -= step;
   l.DrawMathText(x1, y, "\\coloneq");
   l.DrawText(x2, y, "\\coloneq");
   y -= step;
   l.DrawMathText(x1, y, "\\comp");
   l.DrawText(x2, y, "\\comp");
   y -= step;
   l.DrawMathText(x1, y, "\\complement");
   l.DrawText(x2, y, "\\complement");
   y -= step;
   l.DrawMathText(x1, y, "\\cong");
   l.DrawText(x2, y, "\\cong");
   y -= step;
   l.DrawMathText(x1, y, "\\coprod");
   l.DrawText(x2, y, "\\coprod");
   y -= step;
   l.DrawMathText(x1, y, "\\cup");
   l.DrawText(x2, y, "\\cup");
   y -= step;
   l.DrawMathText(x1, y, "\\curlyeqprec");
   l.DrawText(x2, y, "\\curlyeqprec");
   y -= step;
   l.DrawMathText(x1, y, "\\curlyeqsucc");
   l.DrawText(x2, y, "\\curlyeqsucc");
   y -= step;
   l.DrawMathText(x1, y, "\\curlyvee");
   l.DrawText(x2, y, "\\curlyvee");
   y -= step;
   l.DrawMathText(x1, y, "\\curlywedge");
   l.DrawText(x2, y, "\\curlywedge");
   y -= step;
   l.DrawMathText(x1, y, "\\curvearrowleft");
   l.DrawText(x2, y, "\\curvearrowleft");
   y -= step;
   l.DrawMathText(x1, y, "\\dagger");
   l.DrawText(x2, y, "\\dagger");
   y -= step;
   l.DrawMathText(x1, y, "\\daleth");
   l.DrawText(x2, y, "\\daleth");
   y -= step;
   l.DrawMathText(x1, y, "\\dasharrow");
   l.DrawText(x2, y, "\\dasharrow");
   y -= step;
   l.DrawMathText(x1, y, "\\dashdownarrow");
   l.DrawText(x2, y, "\\dashdownarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\dashleftarrow");
   l.DrawText(x2, y, "\\dashleftarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\dashrightarrow");
   l.DrawText(x2, y, "\\dashrightarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\dashuparrow");
   l.DrawText(x2, y, "\\dashuparrow");
   y -= step;
   l.DrawMathText(x1, y, "\\dashv");
   l.DrawText(x2, y, "\\dashv");
   y -= step;
   l.DrawMathText(x1, y, "\\dbar");
   l.DrawText(x2, y, "\\dbar");
   y -= step;
   l.DrawMathText(x1, y, "\\ddagger");
   l.DrawText(x2, y, "\\ddagger");
   y -= step;
   l.DrawMathText(x1, y, "\\ddddot");
   l.DrawText(x2, y, "\\ddddot");
   y -= step;
   l.DrawMathText(x1, y, "\\dddot");
   l.DrawText(x2, y, "\\dddot");
   y -= step;
   l.DrawMathText(x1, y, "\\ddots");
   l.DrawText(x2, y, "\\ddots");
   y -= step;
   l.DrawMathText(x1, y, "\\defineeq");
   l.DrawText(x2, y, "\\defineeq");
   y -= step;
   l.DrawMathText(x1, y, "\\defineequal");
   l.DrawText(x2, y, "\\defineequal");
   y -= step;
   l.DrawMathText(x1, y, "\\delta");
   l.DrawText(x2, y, "\\delta");
   y -= step;
   l.DrawMathText(x1, y, "\\diagdown");
   l.DrawText(x2, y, "\\diagdown");
   y -= step;
   l.DrawMathText(x1, y, "\\diagup");
   l.DrawText(x2, y, "\\diagup");
   y -= step;
   l.DrawMathText(x1, y, "\\diamond");
   l.DrawText(x2, y, "\\diamond");
   y -= step;
   l.DrawMathText(x1, y, "\\diamondsuit");
   l.DrawText(x2, y, "\\diamondsuit");
   y -= step;
   l.DrawMathText(x1, y, "\\digamma");
   l.DrawText(x2, y, "\\digamma");
   y -= step;
   l.DrawMathText(x1, y, "\\digamma");
   l.DrawText(x2, y, "\\digamma");
   y -= step;
   l.DrawMathText(x1, y, "\\div");
   l.DrawText(x2, y, "\\div");
   y -= step;
   l.DrawMathText(x1, y, "\\divideontimes");
   l.DrawText(x2, y, "\\divideontimes");
   y -= step;
   l.DrawMathText(x1, y, "\\doteq");
   l.DrawText(x2, y, "\\doteq");
   y -= step;
   l.DrawMathText(x1, y, "\\doteqdot");
   l.DrawText(x2, y, "\\doteqdot");
   y -= step;
   l.DrawMathText(x1, y, "\\dotplus");
   l.DrawText(x2, y, "\\dotplus");
   y -= step;
   l.DrawMathText(x1, y, "\\doublebarwedge");
   l.DrawText(x2, y, "\\doublebarwedge");
   y -= step;
   l.DrawMathText(x1, y, "\\doublecap");
   l.DrawText(x2, y, "\\doublecap");
   y -= step;
   l.DrawMathText(x1, y, "\\doublecup");
   l.DrawText(x2, y, "\\doublecup");
   y -= step;
   l.DrawMathText(x1, y, "\\downarrow");
   l.DrawText(x2, y, "\\downarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\downdownarrows");
   l.DrawText(x2, y, "\\downdownarrows");
   y -= step;
   l.DrawMathText(x1, y, "\\downdownharpoons");
   l.DrawText(x2, y, "\\downdownharpoons");
   y -= step;
   l.DrawMathText(x1, y, "\\downharpoonleft");
   l.DrawText(x2, y, "\\downharpoonleft");
   y -= step;
   l.DrawMathText(x1, y, "\\downharpoonright");
   l.DrawText(x2, y, "\\downharpoonright");
   y -= step;
   l.DrawMathText(x1, y, "\\downuparrows");
   l.DrawText(x2, y, "\\downuparrows");
   y -= step;
   l.DrawMathText(x1, y, "\\downupharpoons");
   l.DrawText(x2, y, "\\downupharpoons");
   y -= step;
   l.DrawMathText(x1, y, "\\ell");
   l.DrawText(x2, y, "\\ell");
   y -= step;
   l.DrawMathText(x1, y, "\\emptyset");
   l.DrawText(x2, y, "\\emptyset");
   y -= step;
   l.DrawMathText(x1, y, "\\epsilon");
   l.DrawText(x2, y, "\\epsilon");
   y -= step;
   l.DrawMathText(x1, y, "\\eqcirc");
   l.DrawText(x2, y, "\\eqcirc");

   // Draw 3rd Column
   y = 0.99;
   step = 0.0126;
   x1 = 0.27;
   x2 = x1 + 0.02;
   l.DrawMathText(x1, y, "\\eqcolon");
   l.DrawText(x2, y, "\\eqcolon");
   y -= step;
   l.DrawMathText(x1, y, "\\eqsim");
   l.DrawText(x2, y, "\\eqsim");
   y -= step;
   l.DrawMathText(x1, y, "\\eqslantgtr");
   l.DrawText(x2, y, "\\eqslantgtr");
   y -= step;
   l.DrawMathText(x1, y, "\\eqslantless");
   l.DrawText(x2, y, "\\eqslantless");
   y -= step;
   l.DrawMathText(x1, y, "\\equiv");
   l.DrawText(x2, y, "\\equiv");
   y -= step;
   l.DrawMathText(x1, y, "\\eta");
   l.DrawText(x2, y, "\\eta");
   y -= step;
   l.DrawMathText(x1, y, "\\eth");
   l.DrawText(x2, y, "\\eth");
   y -= step;
   l.DrawMathText(x1, y, "\\exists");
   l.DrawText(x2, y, "\\exists");
   y -= step;
   l.DrawMathText(x1, y, "\\fallingdotseq");
   l.DrawText(x2, y, "\\fallingdotseq");
   y -= step;
   l.DrawMathText(x1, y, "\\flat");
   l.DrawText(x2, y, "\\flat");
   y -= step;
   l.DrawMathText(x1, y, "\\forall");
   l.DrawText(x2, y, "\\forall");
   y -= step;
   l.DrawMathText(x1, y, "\\frown");
   l.DrawText(x2, y, "\\frown");
   y -= step;
   l.DrawMathText(x1, y, "\\gamma");
   l.DrawText(x2, y, "\\gamma");
   y -= step;
   l.DrawMathText(x1, y, "\\ge");
   l.DrawText(x2, y, "\\ge");
   y -= step;
   l.DrawMathText(x1, y, "\\geq");
   l.DrawText(x2, y, "\\geq");
   y -= step;
   l.DrawMathText(x1, y, "\\geqq");
   l.DrawText(x2, y, "\\geqq");
   y -= step;
   l.DrawMathText(x1, y, "\\geqslant");
   l.DrawText(x2, y, "\\geqslant");
   y -= step;
   l.DrawMathText(x1, y, "\\gets");
   l.DrawText(x2, y, "\\gets");
   y -= step;
   l.DrawMathText(x1, y, "\\gg");
   l.DrawText(x2, y, "\\gg");
   y -= step;
   l.DrawMathText(x1, y, "\\ggg");
   l.DrawText(x2, y, "\\ggg");
   y -= step;
   l.DrawMathText(x1, y, "\\gggtr");
   l.DrawText(x2, y, "\\gggtr");
   y -= step;
   l.DrawMathText(x1, y, "\\gimel");
   l.DrawText(x2, y, "\\gimel");
   y -= step;
   l.DrawMathText(x1, y, "\\gnapprox");
   l.DrawText(x2, y, "\\gnapprox");
   y -= step;
   l.DrawMathText(x1, y, "\\gneq");
   l.DrawText(x2, y, "\\gneq");
   y -= step;
   l.DrawMathText(x1, y, "\\gneqq");
   l.DrawText(x2, y, "\\gneqq");
   y -= step;
   l.DrawMathText(x1, y, "\\gnsim");
   l.DrawText(x2, y, "\\gnsim");
   y -= step;
   l.DrawMathText(x1, y, "\\gtrapprox");
   l.DrawText(x2, y, "\\gtrapprox");
   y -= step;
   l.DrawMathText(x1, y, "\\gtrdot");
   l.DrawText(x2, y, "\\gtrdot");
   y -= step;
   l.DrawMathText(x1, y, "\\gtreqless");
   l.DrawText(x2, y, "\\gtreqless");
   y -= step;
   l.DrawMathText(x1, y, "\\gtreqqless");
   l.DrawText(x2, y, "\\gtreqqless");
   y -= step;
   l.DrawMathText(x1, y, "\\gtrless");
   l.DrawText(x2, y, "\\gtrless");
   y -= step;
   l.DrawMathText(x1, y, "\\gtrsim");
   l.DrawText(x2, y, "\\gtrsim");
   y -= step;
   l.DrawMathText(x1, y, "\\hateq");
   l.DrawText(x2, y, "\\hateq");
   y -= step;
   l.DrawMathText(x1, y, "\\hbar");
   l.DrawText(x2, y, "\\hbar");
   y -= step;
   l.DrawMathText(x1, y, "\\heartsuit");
   l.DrawText(x2, y, "\\heartsuit");
   y -= step;
   l.DrawMathText(x1, y, "\\hookleftarrow");
   l.DrawText(x2, y, "\\hookleftarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\hookrightarrow");
   l.DrawText(x2, y, "\\hookrightarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\hslash");
   l.DrawText(x2, y, "\\hslash");
   y -= step;
   l.DrawMathText(x1, y, "\\imath");
   l.DrawText(x2, y, "\\imath");
   y -= step;
   l.DrawMathText(x1, y, "\\in");
   l.DrawText(x2, y, "\\in");
   y -= step;
   l.DrawMathText(x1, y, "\\infty");
   l.DrawText(x2, y, "\\infty");
   y -= step;
   l.DrawMathText(x1, y, "\\intercal");
   l.DrawText(x2, y, "\\intercal");
   y -= step;
   l.DrawMathText(x1, y, "\\iota");
   l.DrawText(x2, y, "\\iota");
   y -= step;
   l.DrawMathText(x1, y, "\\jmath");
   l.DrawText(x2, y, "\\jmath");
   y -= step;
   l.DrawMathText(x1, y, "\\kappa");
   l.DrawText(x2, y, "\\kappa");
   y -= step;
   l.DrawMathText(x1, y, "\\koppa");
   l.DrawText(x2, y, "\\koppa");
   y -= step;
   l.DrawMathText(x1, y, "\\lambda");
   l.DrawText(x2, y, "\\lambda");
   y -= step;
   l.DrawMathText(x1, y, "\\land");
   l.DrawText(x2, y, "\\land");
   y -= step;
   l.DrawMathText(x1, y, "\\langle");
   l.DrawText(x2, y, "\\langle");
   y -= step;
   l.DrawMathText(x1, y, "\\lceil");
   l.DrawText(x2, y, "\\lceil");
   y -= step;
   l.DrawMathText(x1, y, "\\ldbrack");
   l.DrawText(x2, y, "\\ldbrack");
   y -= step;
   l.DrawMathText(x1, y, "\\ldots");
   l.DrawText(x2, y, "\\ldots");
   y -= step;
   l.DrawMathText(x1, y, "\\le");
   l.DrawText(x2, y, "\\le");
   y -= step;
   l.DrawMathText(x1, y, "\\leadsfrom");
   l.DrawText(x2, y, "\\leadsfrom");
   y -= step;
   l.DrawMathText(x1, y, "\\leadsto");
   l.DrawText(x2, y, "\\leadsto");
   y -= step;
   l.DrawMathText(x1, y, "\\leftarrow");
   l.DrawText(x2, y, "\\leftarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\leftarrowtail");
   l.DrawText(x2, y, "\\leftarrowtail");
   y -= step;
   l.DrawMathText(x1, y, "\\leftharpoondown");
   l.DrawText(x2, y, "\\leftharpoondown");
   y -= step;
   l.DrawMathText(x1, y, "\\leftharpoonup");
   l.DrawText(x2, y, "\\leftharpoonup");
   y -= step;
   l.DrawMathText(x1, y, "\\leftleftarrows");
   l.DrawText(x2, y, "\\leftleftarrows");
   y -= step;
   l.DrawMathText(x1, y, "\\leftrightarrow");
   l.DrawText(x2, y, "\\leftrightarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\leftrightarrows");
   l.DrawText(x2, y, "\\leftrightarrows");
   y -= step;
   l.DrawMathText(x1, y, "\\leftrightharpoons");
   l.DrawText(x2, y, "\\leftrightharpoons");
   y -= step;
   l.DrawMathText(x1, y, "\\leftsquigarrow");
   l.DrawText(x2, y, "\\leftsquigarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\leftthreetimes");
   l.DrawText(x2, y, "\\leftthreetimes");
   y -= step;
   l.DrawMathText(x1, y, "\\leq");
   l.DrawText(x2, y, "\\leq");
   y -= step;
   l.DrawMathText(x1, y, "\\leqq");
   l.DrawText(x2, y, "\\leqq");
   y -= step;
   l.DrawMathText(x1, y, "\\leqslant");
   l.DrawText(x2, y, "\\leqslant");
   y -= step;
   l.DrawMathText(x1, y, "\\lessapprox");
   l.DrawText(x2, y, "\\lessapprox");
   y -= step;
   l.DrawMathText(x1, y, "\\lessdot");
   l.DrawText(x2, y, "\\lessdot");
   y -= step;
   l.DrawMathText(x1, y, "\\lesseqgtr");
   l.DrawText(x2, y, "\\lesseqgtr");
   y -= step;
   l.DrawMathText(x1, y, "\\lesseqqgtr");
   l.DrawText(x2, y, "\\lesseqqgtr");
   y -= step;
   l.DrawMathText(x1, y, "\\lessgtr");
   l.DrawText(x2, y, "\\lessgtr");
   y -= step;
   l.DrawMathText(x1, y, "\\lesssim");
   l.DrawText(x2, y, "\\lesssim");
   y -= step;
   l.DrawMathText(x1, y, "\\lfloor");
   l.DrawText(x2, y, "\\lfloor");
   y -= step;
   l.DrawMathText(x1, y, "\\lightning");
   l.DrawText(x2, y, "\\lightning");
   y -= step;
   l.DrawMathText(x1, y, "\\ll");
   l.DrawText(x2, y, "\\ll");
   y -= step;
   l.DrawMathText(x1, y, "\\llcorner");
   l.DrawText(x2, y, "\\llcorner");
   y -= step;
   l.DrawMathText(x1, y, "\\lll");
   l.DrawText(x2, y, "\\lll");

   // Draw 4th Column
   y = 0.99;
   step = 0.0126;
   x1 = 0.40;
   x2 = x1 + 0.02;
   l.DrawMathText(x1, y, "\\llless");
   l.DrawText(x2, y, "\\llless");
   y -= step;
   l.DrawMathText(x1, y, "\\lnapprox");
   l.DrawText(x2, y, "\\lnapprox");
   y -= step;
   l.DrawMathText(x1, y, "\\lneq");
   l.DrawText(x2, y, "\\lneq");
   y -= step;
   l.DrawMathText(x1, y, "\\lneqq");
   l.DrawText(x2, y, "\\lneqq");
   y -= step;
   l.DrawMathText(x1, y, "\\lnot");
   l.DrawText(x2, y, "\\lnot");
   y -= step;
   l.DrawMathText(x1, y, "\\lnsim");
   l.DrawText(x2, y, "\\lnsim");
   y -= step;
   l.DrawMathText(x1, y, "\\longleftarrow");
   l.DrawText(x2, y, "\\longleftarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\longleftrightarrow");
   l.DrawText(x2, y, "\\longleftrightarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\longmapsto");
   l.DrawText(x2, y, "\\longmapsto");
   y -= step;
   l.DrawMathText(x1, y, "\\longrightarrow");
   l.DrawText(x2, y, "\\longrightarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\lor");
   l.DrawText(x2, y, "\\lor");
   y -= step;
   l.DrawMathText(x1, y, "\\lozenge");
   l.DrawText(x2, y, "\\lozenge");
   y -= step;
   l.DrawMathText(x1, y, "\\lrcorner");
   l.DrawText(x2, y, "\\lrcorner");
   y -= step;
   l.DrawMathText(x1, y, "\\ltimes");
   l.DrawText(x2, y, "\\ltimes");
   y -= step;
   l.DrawMathText(x1, y, "\\maltese");
   l.DrawText(x2, y, "\\maltese");
   y -= step;
   l.DrawMathText(x1, y, "\\mapsto");
   l.DrawText(x2, y, "\\mapsto");
   y -= step;
   l.DrawMathText(x1, y, "\\measuredangle");
   l.DrawText(x2, y, "\\measuredangle");
   y -= step;
   l.DrawMathText(x1, y, "\\mho");
   l.DrawText(x2, y, "\\mho");
   y -= step;
   l.DrawMathText(x1, y, "\\mp");
   l.DrawText(x2, y, "\\mp");
   y -= step;
   l.DrawMathText(x1, y, "\\mu");
   l.DrawText(x2, y, "\\mu");
   y -= step;
   l.DrawMathText(x1, y, "\\multimap");
   l.DrawText(x2, y, "\\multimap");
   y -= step;
   l.DrawMathText(x1, y, "\\nLeftarrow");
   l.DrawText(x2, y, "\\nLeftarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\nLeftrightarrow");
   l.DrawText(x2, y, "\\nLeftrightarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\nRightarrow");
   l.DrawText(x2, y, "\\nRightarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\nVDash");
   l.DrawText(x2, y, "\\nVDash");
   y -= step;
   l.DrawMathText(x1, y, "\\nVdash");
   l.DrawText(x2, y, "\\nVdash");
   y -= step;
   l.DrawMathText(x1, y, "\\nabla");
   l.DrawText(x2, y, "\\nabla");
   y -= step;
   l.DrawMathText(x1, y, "\\napprox");
   l.DrawText(x2, y, "\\napprox");
   y -= step;
   l.DrawMathText(x1, y, "\\nasymp");
   l.DrawText(x2, y, "\\nasymp");
   y -= step;
   l.DrawMathText(x1, y, "\\natural");
   l.DrawText(x2, y, "\\natural");
   y -= step;
   l.DrawMathText(x1, y, "\\ncong");
   l.DrawText(x2, y, "\\ncong");
   y -= step;
   l.DrawMathText(x1, y, "\\ne");
   l.DrawText(x2, y, "\\ne");
   y -= step;
   l.DrawMathText(x1, y, "\\nearrow");
   l.DrawText(x2, y, "\\nearrow");
   y -= step;
   l.DrawMathText(x1, y, "\\neg");
   l.DrawText(x2, y, "\\neg");
   y -= step;
   l.DrawMathText(x1, y, "\\neq");
   l.DrawText(x2, y, "\\neq");
   y -= step;
   l.DrawMathText(x1, y, "\\nequiv");
   l.DrawText(x2, y, "\\nequiv");
   y -= step;
   l.DrawMathText(x1, y, "\\nexists");
   l.DrawText(x2, y, "\\nexists");
   y -= step;
   l.DrawMathText(x1, y, "\\ngeq");
   l.DrawText(x2, y, "\\ngeq");
   y -= step;
   l.DrawMathText(x1, y, "\\ngeqq");
   l.DrawText(x2, y, "\\ngeqq");
   y -= step;
   l.DrawMathText(x1, y, "\\ngeqslant");
   l.DrawText(x2, y, "\\ngeqslant");
   y -= step;
   l.DrawMathText(x1, y, "\\ngtr");
   l.DrawText(x2, y, "\\ngtr");
   y -= step;
   l.DrawMathText(x1, y, "\\ni");
   l.DrawText(x2, y, "\\ni");
   y -= step;
   l.DrawMathText(x1, y, "\\nleftarrow");
   l.DrawText(x2, y, "\\nleftarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\nleftrightarrow");
   l.DrawText(x2, y, "\\nleftrightarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\nleq");
   l.DrawText(x2, y, "\\nleq");
   y -= step;
   l.DrawMathText(x1, y, "\\nleqq");
   l.DrawText(x2, y, "\\nleqq");
   y -= step;
   l.DrawMathText(x1, y, "\\nleqslant");
   l.DrawText(x2, y, "\\nleqslant");
   y -= step;
   l.DrawMathText(x1, y, "\\nless");
   l.DrawText(x2, y, "\\nless");
   y -= step;
   l.DrawMathText(x1, y, "\\nmid");
   l.DrawText(x2, y, "\\nmid");
   y -= step;
   l.DrawMathText(x1, y, "\\not");
   l.DrawText(x2, y, "\\not");
   y -= step;
   l.DrawMathText(x1, y, "\\notapprox");
   l.DrawText(x2, y, "\\notapprox");
   y -= step;
   l.DrawMathText(x1, y, "\\notasymp");
   l.DrawText(x2, y, "\\notasymp");
   y -= step;
   l.DrawMathText(x1, y, "\\notcong");
   l.DrawText(x2, y, "\\notcong");
   y -= step;
   l.DrawMathText(x1, y, "\\notcong");
   l.DrawText(x2, y, "\\notcong");
   y -= step;
   l.DrawMathText(x1, y, "\\notequiv");
   l.DrawText(x2, y, "\\notequiv");
   y -= step;
   l.DrawMathText(x1, y, "\\notgeq");
   l.DrawText(x2, y, "\\notgeq");
   y -= step;
   l.DrawMathText(x1, y, "\\notgeq");
   l.DrawText(x2, y, "\\notgeq");
   y -= step;
   l.DrawMathText(x1, y, "\\notgr");
   l.DrawText(x2, y, "\\notgr");
   y -= step;
   l.DrawMathText(x1, y, "\\notgr");
   l.DrawText(x2, y, "\\notgr");
   y -= step;
   l.DrawMathText(x1, y, "\\notin");
   l.DrawText(x2, y, "\\notin");
   y -= step;
   l.DrawMathText(x1, y, "\\notleq");
   l.DrawText(x2, y, "\\notleq");
   y -= step;
   l.DrawMathText(x1, y, "\\notleq");
   l.DrawText(x2, y, "\\notleq");
   y -= step;
   l.DrawMathText(x1, y, "\\notless");
   l.DrawText(x2, y, "\\notless");
   y -= step;
   l.DrawMathText(x1, y, "\\notless");
   l.DrawText(x2, y, "\\notless");
   y -= step;
   l.DrawMathText(x1, y, "\\notni");
   l.DrawText(x2, y, "\\notni");
   y -= step;
   l.DrawMathText(x1, y, "\\notprec");
   l.DrawText(x2, y, "\\notprec");
   y -= step;
   l.DrawMathText(x1, y, "\\notprec");
   l.DrawText(x2, y, "\\notprec");
   y -= step;
   l.DrawMathText(x1, y, "\\notsimeq");
   l.DrawText(x2, y, "\\notsimeq");
   y -= step;
   l.DrawMathText(x1, y, "\\notsubset");
   l.DrawText(x2, y, "\\notsubset");
   y -= step;
   l.DrawMathText(x1, y, "\\notsubseteq");
   l.DrawText(x2, y, "\\notsubseteq");
   y -= step;
   l.DrawMathText(x1, y, "\\notsubseteq");
   l.DrawText(x2, y, "\\notsubseteq");
   y -= step;
   l.DrawMathText(x1, y, "\\notsucc");
   l.DrawText(x2, y, "\\notsucc");
   y -= step;
   l.DrawMathText(x1, y, "\\notsucc");
   l.DrawText(x2, y, "\\notsucc");
   y -= step;
   l.DrawMathText(x1, y, "\\notsupset");
   l.DrawText(x2, y, "\\notsupset");
   y -= step;
   l.DrawMathText(x1, y, "\\notsupseteq");
   l.DrawText(x2, y, "\\notsupseteq");
   y -= step;
   l.DrawMathText(x1, y, "\\notsupseteq");
   l.DrawText(x2, y, "\\notsupseteq");
   y -= step;
   l.DrawMathText(x1, y, "\\nparallel");
   l.DrawText(x2, y, "\\nparallel");
   y -= step;
   l.DrawMathText(x1, y, "\\nprec");
   l.DrawText(x2, y, "\\nprec");
   y -= step;
   l.DrawMathText(x1, y, "\\nrightarrow");
   l.DrawText(x2, y, "\\nrightarrow");

   // Draw 5th Column
   y = 0.99;
   step = 0.0126;
   x1 = 0.53;
   x2 = x1 + 0.02;
   l.DrawMathText(x1, y, "\\nsim");
   l.DrawText(x2, y, "\\nsim");
   y -= step;
   l.DrawMathText(x1, y, "\\nsim");
   l.DrawText(x2, y, "\\nsim");
   y -= step;
   l.DrawMathText(x1, y, "\\nsimeq");
   l.DrawText(x2, y, "\\nsimeq");
   y -= step;
   l.DrawMathText(x1, y, "\\nsubset");
   l.DrawText(x2, y, "\\nsubset");
   y -= step;
   l.DrawMathText(x1, y, "\\nsubseteq");
   l.DrawText(x2, y, "\\nsubseteq");
   y -= step;
   l.DrawMathText(x1, y, "\\nsubseteqq");
   l.DrawText(x2, y, "\\nsubseteqq");
   y -= step;
   l.DrawMathText(x1, y, "\\nsucc");
   l.DrawText(x2, y, "\\nsucc");
   y -= step;
   l.DrawMathText(x1, y, "\\nsupset");
   l.DrawText(x2, y, "\\nsupset");
   y -= step;
   l.DrawMathText(x1, y, "\\nsupseteq");
   l.DrawText(x2, y, "\\nsupseteq");
   y -= step;
   l.DrawMathText(x1, y, "\\nsupseteqq");
   l.DrawText(x2, y, "\\nsupseteqq");
   y -= step;
   l.DrawMathText(x1, y, "\\ntriangleleft");
   l.DrawText(x2, y, "\\ntriangleleft");
   y -= step;
   l.DrawMathText(x1, y, "\\ntrianglelefteq");
   l.DrawText(x2, y, "\\ntrianglelefteq");
   y -= step;
   l.DrawMathText(x1, y, "\\ntriangleright");
   l.DrawText(x2, y, "\\ntriangleright");
   y -= step;
   l.DrawMathText(x1, y, "\\ntrianglerighteq");
   l.DrawText(x2, y, "\\ntrianglerighteq");
   y -= step;
   l.DrawMathText(x1, y, "\\nu");
   l.DrawText(x2, y, "\\nu");
   y -= step;
   l.DrawMathText(x1, y, "\\nvDash");
   l.DrawText(x2, y, "\\nvDash");
   y -= step;
   l.DrawMathText(x1, y, "\\nvdash");
   l.DrawText(x2, y, "\\nvdash");
   y -= step;
   l.DrawMathText(x1, y, "\\nwarrow");
   l.DrawText(x2, y, "\\nwarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\odot");
   l.DrawText(x2, y, "\\odot");
   y -= step;
   l.DrawMathText(x1, y, "\\omega");
   l.DrawText(x2, y, "\\omega");
   y -= step;
   l.DrawMathText(x1, y, "\\ominus");
   l.DrawText(x2, y, "\\ominus");
   y -= step;
   l.DrawMathText(x1, y, "\\openclubsuit");
   l.DrawText(x2, y, "\\openclubsuit");
   y -= step;
   l.DrawMathText(x1, y, "\\openspadesuit");
   l.DrawText(x2, y, "\\openspadesuit");
   y -= step;
   l.DrawMathText(x1, y, "\\oplus");
   l.DrawText(x2, y, "\\oplus");
   y -= step;
   l.DrawMathText(x1, y, "\\oslash");
   l.DrawText(x2, y, "\\oslash");
   y -= step;
   l.DrawMathText(x1, y, "\\otimes");
   l.DrawText(x2, y, "\\otimes");
   y -= step;
   l.DrawMathText(x1, y, "\\owns");
   l.DrawText(x2, y, "\\owns");
   y -= step;
   l.DrawMathText(x1, y, "\\parallel");
   l.DrawText(x2, y, "\\parallel");
   y -= step;
   l.DrawMathText(x1, y, "\\partial");
   l.DrawText(x2, y, "\\partial");
   y -= step;
   l.DrawMathText(x1, y, "\\perp");
   l.DrawText(x2, y, "\\perp");
   y -= step;
   l.DrawMathText(x1, y, "\\phi");
   l.DrawText(x2, y, "\\phi");
   y -= step;
   l.DrawMathText(x1, y, "\\pi");
   l.DrawText(x2, y, "\\pi");
   y -= step;
   l.DrawMathText(x1, y, "\\pitchfork");
   l.DrawText(x2, y, "\\pitchfork");
   y -= step;
   l.DrawMathText(x1, y, "\\pm");
   l.DrawText(x2, y, "\\pm");
   y -= step;
   l.DrawMathText(x1, y, "\\prec");
   l.DrawText(x2, y, "\\prec");
   y -= step;
   l.DrawMathText(x1, y, "\\precapprox");
   l.DrawText(x2, y, "\\precapprox");
   y -= step;
   l.DrawMathText(x1, y, "\\preccurlyeq");
   l.DrawText(x2, y, "\\preccurlyeq");
   y -= step;
   l.DrawMathText(x1, y, "\\preceq");
   l.DrawText(x2, y, "\\preceq");
   y -= step;
   l.DrawMathText(x1, y, "\\precnapprox");
   l.DrawText(x2, y, "\\precnapprox");
   y -= step;
   l.DrawMathText(x1, y, "\\precneqq");
   l.DrawText(x2, y, "\\precneqq");
   y -= step;
   l.DrawMathText(x1, y, "\\precnsim");
   l.DrawText(x2, y, "\\precnsim");
   y -= step;
   l.DrawMathText(x1, y, "\\precsim");
   l.DrawText(x2, y, "\\precsim");
   y -= step;
   l.DrawMathText(x1, y, "\\prime");
   l.DrawText(x2, y, "\\prime");
   y -= step;
   l.DrawMathText(x1, y, "\\propto");
   l.DrawText(x2, y, "\\propto");
   y -= step;
   l.DrawMathText(x1, y, "\\psi");
   l.DrawText(x2, y, "\\psi");
   y -= step;
   l.DrawMathText(x1, y, "\\rangle");
   l.DrawText(x2, y, "\\rangle");
   y -= step;
   l.DrawMathText(x1, y, "\\rceil");
   l.DrawText(x2, y, "\\rceil");
   y -= step;
   l.DrawMathText(x1, y, "\\rdbrack");
   l.DrawText(x2, y, "\\rdbrack");
   y -= step;
   l.DrawMathText(x1, y, "\\restriction");
   l.DrawText(x2, y, "\\restriction");
   y -= step;
   l.DrawMathText(x1, y, "\\rfloor");
   l.DrawText(x2, y, "\\rfloor");
   y -= step;
   l.DrawMathText(x1, y, "\\rho");
   l.DrawText(x2, y, "\\rho");
   y -= step;
   l.DrawMathText(x1, y, "\\rightarrow");
   l.DrawText(x2, y, "\\rightarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\rightarrowtail");
   l.DrawText(x2, y, "\\rightarrowtail");
   y -= step;
   l.DrawMathText(x1, y, "\\rightharpoondown");
   l.DrawText(x2, y, "\\rightharpoondown");
   y -= step;
   l.DrawMathText(x1, y, "\\rightharpoonup");
   l.DrawText(x2, y, "\\rightharpoonup");
   y -= step;
   l.DrawMathText(x1, y, "\\rightleftarrows");
   l.DrawText(x2, y, "\\rightleftarrows");
   y -= step;
   l.DrawMathText(x1, y, "\\rightleftharpoons");
   l.DrawText(x2, y, "\\rightleftharpoons");
   y -= step;
   l.DrawMathText(x1, y, "\\rightrightarrows");
   l.DrawText(x2, y, "\\rightrightarrows");
   y -= step;
   l.DrawMathText(x1, y, "\\rightsquigarrow");
   l.DrawText(x2, y, "\\rightsquigarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\rightthreetimes");
   l.DrawText(x2, y, "\\rightthreetimes");
   y -= step;
   l.DrawMathText(x1, y, "\\risingdotseq");
   l.DrawText(x2, y, "\\risingdotseq");
   y -= step;
   l.DrawMathText(x1, y, "\\rtimes");
   l.DrawText(x2, y, "\\rtimes");
   y -= step;
   l.DrawMathText(x1, y, "\\sampi");
   l.DrawText(x2, y, "\\sampi");
   y -= step;
   l.DrawMathText(x1, y, "\\san");
   l.DrawText(x2, y, "\\san");
   y -= step;
   l.DrawMathText(x1, y, "\\searrow");
   l.DrawText(x2, y, "\\searrow");
   y -= step;
   l.DrawMathText(x1, y, "\\setdif");
   l.DrawText(x2, y, "\\setdif");
   y -= step;
   l.DrawMathText(x1, y, "\\sharp");
   l.DrawText(x2, y, "\\sharp");
   y -= step;
   l.DrawMathText(x1, y, "\\sho");
   l.DrawText(x2, y, "\\sho");
   y -= step;
   l.DrawMathText(x1, y, "\\sigma");
   l.DrawText(x2, y, "\\sigma");
   y -= step;
   l.DrawMathText(x1, y, "\\sim");
   l.DrawText(x2, y, "\\sim");
   y -= step;
   l.DrawMathText(x1, y, "\\simarrow");
   l.DrawText(x2, y, "\\simarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\simeq");
   l.DrawText(x2, y, "\\simeq");
   y -= step;
   l.DrawMathText(x1, y, "\\smallfrown");
   l.DrawText(x2, y, "\\smallfrown");
   y -= step;
   l.DrawMathText(x1, y, "\\smallint");
   l.DrawText(x2, y, "\\smallint");
   y -= step;
   l.DrawMathText(x1, y, "\\smallsetminus");
   l.DrawText(x2, y, "\\smallsetminus");
   y -= step;
   l.DrawMathText(x1, y, "\\smallsmile");
   l.DrawText(x2, y, "\\smallsmile");
   y -= step;
   l.DrawMathText(x1, y, "\\smile");
   l.DrawText(x2, y, "\\smile");
   y -= step;
   l.DrawMathText(x1, y, "\\spadesuit");
   l.DrawText(x2, y, "\\spadesuit");
   y -= step;
   l.DrawMathText(x1, y, "\\sphericalangle");
   l.DrawText(x2, y, "\\sphericalangle");

   // Draw 6th Column
   y = 0.99;
   step = 0.0126;
   x1 = 0.66;
   x2 = x1 + 0.02;
   l.DrawMathText(x1, y, "\\sqcap");
   l.DrawText(x2, y, "\\sqcap");
   y -= step;
   l.DrawMathText(x1, y, "\\sqcup");
   l.DrawText(x2, y, "\\sqcup");
   y -= step;
   l.DrawMathText(x1, y, "\\sqsubset");
   l.DrawText(x2, y, "\\sqsubset");
   y -= step;
   l.DrawMathText(x1, y, "\\sqsubseteq");
   l.DrawText(x2, y, "\\sqsubseteq");
   y -= step;
   l.DrawMathText(x1, y, "\\sqsupset");
   l.DrawText(x2, y, "\\sqsupset");
   y -= step;
   l.DrawMathText(x1, y, "\\sqsupseteq");
   l.DrawText(x2, y, "\\sqsupseteq");
   y -= step;
   l.DrawMathText(x1, y, "\\square");
   l.DrawText(x2, y, "\\square");
   y -= step;
   l.DrawMathText(x1, y, "\\star");
   l.DrawText(x2, y, "\\star");
   y -= step;
   l.DrawMathText(x1, y, "\\stigma");
   l.DrawText(x2, y, "\\stigma");
   y -= step;
   l.DrawMathText(x1, y, "\\subset");
   l.DrawText(x2, y, "\\subset");
   y -= step;
   l.DrawMathText(x1, y, "\\subseteq");
   l.DrawText(x2, y, "\\subseteq");
   y -= step;
   l.DrawMathText(x1, y, "\\subseteqq");
   l.DrawText(x2, y, "\\subseteqq");
   y -= step;
   l.DrawMathText(x1, y, "\\subsetneq");
   l.DrawText(x2, y, "\\subsetneq");
   y -= step;
   l.DrawMathText(x1, y, "\\subsetneqq");
   l.DrawText(x2, y, "\\subsetneqq");
   y -= step;
   l.DrawMathText(x1, y, "\\succ");
   l.DrawText(x2, y, "\\succ");
   y -= step;
   l.DrawMathText(x1, y, "\\succapprox");
   l.DrawText(x2, y, "\\succapprox");
   y -= step;
   l.DrawMathText(x1, y, "\\succcurlyeq");
   l.DrawText(x2, y, "\\succcurlyeq");
   y -= step;
   l.DrawMathText(x1, y, "\\succeq");
   l.DrawText(x2, y, "\\succeq");
   y -= step;
   l.DrawMathText(x1, y, "\\succnapprox");
   l.DrawText(x2, y, "\\succnapprox");
   y -= step;
   l.DrawMathText(x1, y, "\\succneqq");
   l.DrawText(x2, y, "\\succneqq");
   y -= step;
   l.DrawMathText(x1, y, "\\succnsim");
   l.DrawText(x2, y, "\\succnsim");
   y -= step;
   l.DrawMathText(x1, y, "\\succsim");
   l.DrawText(x2, y, "\\succsim");
   y -= step;
   l.DrawMathText(x1, y, "\\supset");
   l.DrawText(x2, y, "\\supset");
   y -= step;
   l.DrawMathText(x1, y, "\\supseteq");
   l.DrawText(x2, y, "\\supseteq");
   y -= step;
   l.DrawMathText(x1, y, "\\supseteqq");
   l.DrawText(x2, y, "\\supseteqq");
   y -= step;
   l.DrawMathText(x1, y, "\\supsetneq");
   l.DrawText(x2, y, "\\supsetneq");
   y -= step;
   l.DrawMathText(x1, y, "\\supsetneqq");
   l.DrawText(x2, y, "\\supsetneqq");
   y -= step;
   l.DrawMathText(x1, y, "\\surd");
   l.DrawText(x2, y, "\\surd");
   y -= step;
   l.DrawMathText(x1, y, "\\swarrow");
   l.DrawText(x2, y, "\\swarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\t");
   l.DrawText(x2, y, "\\t");
   y -= step;
   l.DrawMathText(x1, y, "\\tau");
   l.DrawText(x2, y, "\\tau");
   y -= step;
   l.DrawMathText(x1, y, "\\therefore");
   l.DrawText(x2, y, "\\therefore");
   y -= step;
   l.DrawMathText(x1, y, "\\theta");
   l.DrawText(x2, y, "\\theta");
   y -= step;
   l.DrawMathText(x1, y, "\\times");
   l.DrawText(x2, y, "\\times");
   y -= step;
   l.DrawMathText(x1, y, "\\to");
   l.DrawText(x2, y, "\\to");
   y -= step;
   l.DrawMathText(x1, y, "\\top");
   l.DrawText(x2, y, "\\top");
   y -= step;
   l.DrawMathText(x1, y, "\\triangledown");
   l.DrawText(x2, y, "\\triangledown");
   y -= step;
   l.DrawMathText(x1, y, "\\triangleleft");
   l.DrawText(x2, y, "\\triangleleft");
   y -= step;
   l.DrawMathText(x1, y, "\\triangleleft");
   l.DrawText(x2, y, "\\triangleleft");
   y -= step;
   l.DrawMathText(x1, y, "\\trianglelefteq");
   l.DrawText(x2, y, "\\trianglelefteq");
   y -= step;
   l.DrawMathText(x1, y, "\\triangleq");
   l.DrawText(x2, y, "\\triangleq");
   y -= step;
   l.DrawMathText(x1, y, "\\triangleright");
   l.DrawText(x2, y, "\\triangleright");
   y -= step;
   l.DrawMathText(x1, y, "\\trianglerighteq");
   l.DrawText(x2, y, "\\trianglerighteq");
   y -= step;
   l.DrawMathText(x1, y, "\\twoheadleftarrow");
   l.DrawText(x2, y, "\\twoheadleftarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\twoheadrightarrow");
   l.DrawText(x2, y, "\\twoheadrightarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\u");
   l.DrawText(x2, y, "\\u");
   y -= step;
   l.DrawMathText(x1, y, "\\ulcorner");
   l.DrawText(x2, y, "\\ulcorner");
   y -= step;
   l.DrawMathText(x1, y, "\\undercurvearrowright");
   l.DrawText(x2, y, "\\undercurvearrowright");
   y -= step;
   l.DrawMathText(x1, y, "\\upDelta");
   l.DrawText(x2, y, "\\upDelta");
   y -= step;
   l.DrawMathText(x1, y, "\\upDigamma");
   l.DrawText(x2, y, "\\upDigamma");
   y -= step;
   l.DrawMathText(x1, y, "\\upGamma");
   l.DrawText(x2, y, "\\upGamma");
   y -= step;
   l.DrawMathText(x1, y, "\\upKoppa");
   l.DrawText(x2, y, "\\upKoppa");
   y -= step;
   l.DrawMathText(x1, y, "\\upLambda");
   l.DrawText(x2, y, "\\upLambda");
   y -= step;
   l.DrawMathText(x1, y, "\\upOmega");
   l.DrawText(x2, y, "\\upOmega");
   y -= step;
   l.DrawMathText(x1, y, "\\upPhi");
   l.DrawText(x2, y, "\\upPhi");
   y -= step;
   l.DrawMathText(x1, y, "\\upPi");
   l.DrawText(x2, y, "\\upPi");
   y -= step;
   l.DrawMathText(x1, y, "\\upPsi");
   l.DrawText(x2, y, "\\upPsi");
   y -= step;
   l.DrawMathText(x1, y, "\\upSampi");
   l.DrawText(x2, y, "\\upSampi");
   y -= step;
   l.DrawMathText(x1, y, "\\upSan");
   l.DrawText(x2, y, "\\upSan");
   y -= step;
   l.DrawMathText(x1, y, "\\upSho");
   l.DrawText(x2, y, "\\upSho");
   y -= step;
   l.DrawMathText(x1, y, "\\upSigma");
   l.DrawText(x2, y, "\\upSigma");
   y -= step;
   l.DrawMathText(x1, y, "\\upStigma");
   l.DrawText(x2, y, "\\upStigma");
   y -= step;
   l.DrawMathText(x1, y, "\\upTheta");
   l.DrawText(x2, y, "\\upTheta");
   y -= step;
   l.DrawMathText(x1, y, "\\upUpsilon");
   l.DrawText(x2, y, "\\upUpsilon");
   y -= step;
   l.DrawMathText(x1, y, "\\upVarKoppa");
   l.DrawText(x2, y, "\\upVarKoppa");
   y -= step;
   l.DrawMathText(x1, y, "\\upXi");
   l.DrawText(x2, y, "\\upXi");
   y -= step;
   l.DrawMathText(x1, y, "\\upalpha");
   l.DrawText(x2, y, "\\upalpha");
   y -= step;
   l.DrawMathText(x1, y, "\\uparrow");
   l.DrawText(x2, y, "\\uparrow");
   y -= step;
   l.DrawMathText(x1, y, "\\upbeta");
   l.DrawText(x2, y, "\\upbeta");
   y -= step;
   l.DrawMathText(x1, y, "\\upchi");
   l.DrawText(x2, y, "\\upchi");
   y -= step;
   l.DrawMathText(x1, y, "\\updbar");
   l.DrawText(x2, y, "\\updbar");
   y -= step;
   l.DrawMathText(x1, y, "\\updelta");
   l.DrawText(x2, y, "\\updelta");
   y -= step;
   l.DrawMathText(x1, y, "\\updigamma");
   l.DrawText(x2, y, "\\updigamma");
   y -= step;
   l.DrawMathText(x1, y, "\\updownarrow");
   l.DrawText(x2, y, "\\updownarrow");
   y -= step;
   l.DrawMathText(x1, y, "\\updownarrows");
   l.DrawText(x2, y, "\\updownarrows");
   y -= step;
   l.DrawMathText(x1, y, "\\updownharpoons");
   l.DrawText(x2, y, "\\updownharpoons");
   y -= step;
   l.DrawMathText(x1, y, "\\upepsilon");
   l.DrawText(x2, y, "\\upepsilon");
   y -= step;
   l.DrawMathText(x1, y, "\\upeta");
   l.DrawText(x2, y, "\\upeta");
   y -= step;
   l.DrawMathText(x1, y, "\\upgamma");
   l.DrawText(x2, y, "\\upgamma");

   // Draw 7th Column
   y = 0.99;
   step = 0.0126;
   x1 = 0.79;
   x2 = x1 + 0.02;
   l.DrawMathText(x1, y, "\\upharpoonleft");
   l.DrawText(x2, y, "\\upharpoonleft");
   y -= step;
   l.DrawMathText(x1, y, "\\upharpoonright");
   l.DrawText(x2, y, "\\upharpoonright");
   y -= step;
   l.DrawMathText(x1, y, "\\upiota");
   l.DrawText(x2, y, "\\upiota");
   y -= step;
   l.DrawMathText(x1, y, "\\upkappa");
   l.DrawText(x2, y, "\\upkappa");
   y -= step;
   l.DrawMathText(x1, y, "\\upkoppa");
   l.DrawText(x2, y, "\\upkoppa");
   y -= step;
   l.DrawMathText(x1, y, "\\uplambda");
   l.DrawText(x2, y, "\\uplambda");
   y -= step;
   l.DrawMathText(x1, y, "\\uplus");
   l.DrawText(x2, y, "\\uplus");
   y -= step;
   l.DrawMathText(x1, y, "\\upmu");
   l.DrawText(x2, y, "\\upmu");
   y -= step;
   l.DrawMathText(x1, y, "\\upnu");
   l.DrawText(x2, y, "\\upnu");
   y -= step;
   l.DrawMathText(x1, y, "\\upomega");
   l.DrawText(x2, y, "\\upomega");
   y -= step;
   l.DrawMathText(x1, y, "\\upphi");
   l.DrawText(x2, y, "\\upphi");
   y -= step;
   l.DrawMathText(x1, y, "\\uppi");
   l.DrawText(x2, y, "\\uppi");
   y -= step;
   l.DrawMathText(x1, y, "\\uppsi");
   l.DrawText(x2, y, "\\uppsi");
   y -= step;
   l.DrawMathText(x1, y, "\\uprho");
   l.DrawText(x2, y, "\\uprho");
   y -= step;
   l.DrawMathText(x1, y, "\\upsampi");
   l.DrawText(x2, y, "\\upsampi");
   y -= step;
   l.DrawMathText(x1, y, "\\upsan");
   l.DrawText(x2, y, "\\upsan");
   y -= step;
   l.DrawMathText(x1, y, "\\upsho");
   l.DrawText(x2, y, "\\upsho");
   y -= step;
   l.DrawMathText(x1, y, "\\upsigma");
   l.DrawText(x2, y, "\\upsigma");
   y -= step;
   l.DrawMathText(x1, y, "\\upsilon");
   l.DrawText(x2, y, "\\upsilon");
   y -= step;
   l.DrawMathText(x1, y, "\\upstigma");
   l.DrawText(x2, y, "\\upstigma");
   y -= step;
   l.DrawMathText(x1, y, "\\uptau");
   l.DrawText(x2, y, "\\uptau");
   y -= step;
   l.DrawMathText(x1, y, "\\uptheta");
   l.DrawText(x2, y, "\\uptheta");
   y -= step;
   l.DrawMathText(x1, y, "\\upuparrows");
   l.DrawText(x2, y, "\\upuparrows");
   y -= step;
   l.DrawMathText(x1, y, "\\upupharpoons");
   l.DrawText(x2, y, "\\upupharpoons");
   y -= step;
   l.DrawMathText(x1, y, "\\upupsilon");
   l.DrawText(x2, y, "\\upupsilon");
   y -= step;
   l.DrawMathText(x1, y, "\\upvarbeta");
   l.DrawText(x2, y, "\\upvarbeta");
   y -= step;
   l.DrawMathText(x1, y, "\\upvarepsilon");
   l.DrawText(x2, y, "\\upvarepsilon");
   y -= step;
   l.DrawMathText(x1, y, "\\upvarkappa");
   l.DrawText(x2, y, "\\upvarkappa");
   y -= step;
   l.DrawMathText(x1, y, "\\upvarkoppa");
   l.DrawText(x2, y, "\\upvarkoppa");
   y -= step;
   l.DrawMathText(x1, y, "\\upvarphi");
   l.DrawText(x2, y, "\\upvarphi");
   y -= step;
   l.DrawMathText(x1, y, "\\upvarpi");
   l.DrawText(x2, y, "\\upvarpi");
   y -= step;
   l.DrawMathText(x1, y, "\\upvarrho");
   l.DrawText(x2, y, "\\upvarrho");
   y -= step;
   l.DrawMathText(x1, y, "\\upvarsigma");
   l.DrawText(x2, y, "\\upvarsigma");
   y -= step;
   l.DrawMathText(x1, y, "\\upvartheta");
   l.DrawText(x2, y, "\\upvartheta");
   y -= step;
   l.DrawMathText(x1, y, "\\upxi");
   l.DrawText(x2, y, "\\upxi");
   y -= step;
   l.DrawMathText(x1, y, "\\upzeta");
   l.DrawText(x2, y, "\\upzeta");
   y -= step;
   l.DrawMathText(x1, y, "\\urcorner");
   l.DrawText(x2, y, "\\urcorner");
   y -= step;
   l.DrawMathText(x1, y, "\\v");
   l.DrawText(x2, y, "\\v");
   y -= step;
   l.DrawMathText(x1, y, "\\vDash");
   l.DrawText(x2, y, "\\vDash");
   y -= step;
   l.DrawMathText(x1, y, "\\vDash");
   l.DrawText(x2, y, "\\vDash");
   y -= step;
   l.DrawMathText(x1, y, "\\varbeta");
   l.DrawText(x2, y, "\\varbeta");
   y -= step;
   l.DrawMathText(x1, y, "\\varepsilon");
   l.DrawText(x2, y, "\\varepsilon");
   y -= step;
   l.DrawMathText(x1, y, "\\varkappa");
   l.DrawText(x2, y, "\\varkappa");
   y -= step;
   l.DrawMathText(x1, y, "\\varkoppa");
   l.DrawText(x2, y, "\\varkoppa");
   y -= step;
   l.DrawMathText(x1, y, "\\varnothing");
   l.DrawText(x2, y, "\\varnothing");
   y -= step;
   l.DrawMathText(x1, y, "\\varphi");
   l.DrawText(x2, y, "\\varphi");
   y -= step;
   l.DrawMathText(x1, y, "\\varpi");
   l.DrawText(x2, y, "\\varpi");
   y -= step;
   l.DrawMathText(x1, y, "\\varpropto");
   l.DrawText(x2, y, "\\varpropto");
   y -= step;
   l.DrawMathText(x1, y, "\\varrho");
   l.DrawText(x2, y, "\\varrho");
   y -= step;
   l.DrawMathText(x1, y, "\\varsigma");
   l.DrawText(x2, y, "\\varsigma");
   y -= step;
   l.DrawMathText(x1, y, "\\vartheta");
   l.DrawText(x2, y, "\\vartheta");
   y -= step;
   l.DrawMathText(x1, y, "\\vartriangle");
   l.DrawText(x2, y, "\\vartriangle");
   y -= step;
   l.DrawMathText(x1, y, "\\vartriangleleft");
   l.DrawText(x2, y, "\\vartriangleleft");
   y -= step;
   l.DrawMathText(x1, y, "\\vartriangleright");
   l.DrawText(x2, y, "\\vartriangleright");
   y -= step;
   l.DrawMathText(x1, y, "\\vdash");
   l.DrawText(x2, y, "\\vdash");
   y -= step;
   l.DrawMathText(x1, y, "\\vdots");
   l.DrawText(x2, y, "\\vdots");
   y -= step;
   l.DrawMathText(x1, y, "\\vec");
   l.DrawText(x2, y, "\\vec");
   y -= step;
   l.DrawMathText(x1, y, "\\vee");
   l.DrawText(x2, y, "\\vee");
   y -= step;
   l.DrawMathText(x1, y, "\\veebar");
   l.DrawText(x2, y, "\\veebar");
   y -= step;
   l.DrawMathText(x1, y, "\\vert");
   l.DrawText(x2, y, "\\vert");
   y -= step;
   l.DrawMathText(x1, y, "\\wedge");
   l.DrawText(x2, y, "\\wedge");
   y -= step;
   l.DrawMathText(x1, y, "\\wp");
   l.DrawText(x2, y, "\\wp");
   y -= step;
   l.DrawMathText(x1, y, "\\wr");
   l.DrawText(x2, y, "\\wr");
   y -= step;
   l.DrawMathText(x1, y, "\\wwbar");
   l.DrawText(x2, y, "\\wwbar");
   y -= step;
   l.DrawMathText(x1, y, "\\xi");
   l.DrawText(x2, y, "\\xi");
   y -= step;
   l.DrawMathText(x1, y, "\\yen");
   l.DrawText(x2, y, "\\yen");
   y -= step;
   l.DrawMathText(x1, y, "\\zeta");
   l.DrawText(x2, y, "\\zeta");
   y -= step;
   l.DrawMathText(x1, y, "\\{");
   l.DrawText(x2, y, "\\{");
   y -= step;
   l.DrawMathText(x1, y, "\\|");
   l.DrawText(x2, y, "\\|");
   y -= step;
   l.DrawMathText(x1, y, "\\}");
   l.DrawText(x2, y, "\\}");
   y -= step;
   l.DrawMathText(x1, y, "\\~");
   l.DrawText(x2, y, "\\~");
   y -= step;
   l.DrawMathText(x1, y, "\\Pr");
   l.DrawText(x2, y, "\\Pr");
   y -= step;
   l.DrawMathText(x1, y, "\\awoint");
   l.DrawText(x2, y, "\\awoint");
   y -= step;
   l.DrawMathText(x1, y, "\\awointop");
   l.DrawText(x2, y, "\\awointop");
   y -= step;
   l.DrawMathText(x1, y, "\\barint");
   l.DrawText(x2, y, "\\barint");
   y -= step;
   l.DrawMathText(x1, y, "\\barintop");
   l.DrawText(x2, y, "\\barintop");
   y -= step;
   l.DrawMathText(x1, y, "\\bigcap");
   l.DrawText(x2, y, "\\bigcap");
   y -= step;
   l.DrawMathText(x1, y, "\\bigcup");
   l.DrawText(x2, y, "\\bigcup");
   y -= step;
   l.DrawMathText(x1, y, "\\bigodot");
   l.DrawText(x2, y, "\\bigodot");

   // Draw 8th Column
   y = 0.99;
   step = 0.0126;
   x1 = 0.92;
   x2 = x1 + 0.02;
   l.DrawMathText(x1, y, "\\bigoplus");
   l.DrawText(x2, y, "\\bigoplus");
   y -= step;
   l.DrawMathText(x1, y, "\\bigotimes");
   l.DrawText(x2, y, "\\bigotimes");
   y -= step;
   l.DrawMathText(x1, y, "\\bigsqcup");
   l.DrawText(x2, y, "\\bigsqcup");
   y -= step;
   l.DrawMathText(x1, y, "\\biguplus");
   l.DrawText(x2, y, "\\biguplus");
   y -= step;
   l.DrawMathText(x1, y, "\\bigvee");
   l.DrawText(x2, y, "\\bigvee");
   y -= step;
   l.DrawMathText(x1, y, "\\bigwedge");
   l.DrawText(x2, y, "\\bigwedge");
   y -= step;
   l.DrawMathText(x1, y, "\\coprod");
   l.DrawText(x2, y, "\\coprod");
   y -= step;
   l.DrawMathText(x1, y, "\\cwint");
   l.DrawText(x2, y, "\\cwint");
   y -= step;
   l.DrawMathText(x1, y, "\\cwintop");
   l.DrawText(x2, y, "\\cwintop");
   y -= step;
   l.DrawMathText(x1, y, "\\cwoint");
   l.DrawText(x2, y, "\\cwoint");
   y -= step;
   l.DrawMathText(x1, y, "\\cwointop");
   l.DrawText(x2, y, "\\cwointop");
   y -= step;
   l.DrawMathText(x1, y, "\\iiint");
   l.DrawText(x2, y, "\\iiint");
   y -= step;
   l.DrawMathText(x1, y, "\\iiintop");
   l.DrawText(x2, y, "\\iiintop");
   y -= step;
   l.DrawMathText(x1, y, "\\iint");
   l.DrawText(x2, y, "\\iint");
   y -= step;
   l.DrawMathText(x1, y, "\\iintop");
   l.DrawText(x2, y, "\\iintop");
   y -= step;
   l.DrawMathText(x1, y, "\\int");
   l.DrawText(x2, y, "\\int");
   y -= step;
   l.DrawMathText(x1, y, "\\intop");
   l.DrawText(x2, y, "\\intop");
   y -= step;
   l.DrawMathText(x1, y, "\\oiiint");
   l.DrawText(x2, y, "\\oiiint");
   y -= step;
   l.DrawMathText(x1, y, "\\oiiintop");
   l.DrawText(x2, y, "\\oiiintop");
   y -= step;
   l.DrawMathText(x1, y, "\\oiint");
   l.DrawText(x2, y, "\\oiint");
   y -= step;
   l.DrawMathText(x1, y, "\\oiintop");
   l.DrawText(x2, y, "\\oiintop");
   y -= step;
   l.DrawMathText(x1, y, "\\oint");
   l.DrawText(x2, y, "\\oint");
   y -= step;
   l.DrawMathText(x1, y, "\\ointop");
   l.DrawText(x2, y, "\\ointop");
   y -= step;
   l.DrawMathText(x1, y, "\\prod");
   l.DrawText(x2, y, "\\prod");
   y -= step;
   l.DrawMathText(x1, y, "\\slashint");
   l.DrawText(x2, y, "\\slashint");
   y -= step;
   l.DrawMathText(x1, y, "\\slashintop");
   l.DrawText(x2, y, "\\slashintop");
   y -= step;
   l.DrawMathText(x1, y, "\\sum");
   l.DrawText(x2, y, "\\sum");

   x2 = x2 + 0.02;
   y -= step;
   l.DrawMathText(x1, y, "\\arccos");
   l.DrawText(x2, y, "\\arccos");
   y -= step;
   l.DrawMathText(x1, y, "\\arcsin");
   l.DrawText(x2, y, "\\arcsin");
   y -= step;
   l.DrawMathText(x1, y, "\\arctan");
   l.DrawText(x2, y, "\\arctan");
   y -= step;
   l.DrawMathText(x1, y, "\\arg");
   l.DrawText(x2, y, "\\arg");
   y -= step;
   l.DrawMathText(x1, y, "\\cos");
   l.DrawText(x2, y, "\\cos");
   y -= step;
   l.DrawMathText(x1, y, "\\cosh");
   l.DrawText(x2, y, "\\cosh");
   y -= step;
   l.DrawMathText(x1, y, "\\cot");
   l.DrawText(x2, y, "\\cot");
   y -= step;
   l.DrawMathText(x1, y, "\\coth");
   l.DrawText(x2, y, "\\coth");
   y -= step;
   l.DrawMathText(x1, y, "\\csc");
   l.DrawText(x2, y, "\\csc");
   y -= step;
   l.DrawMathText(x1, y, "\\deg");
   l.DrawText(x2, y, "\\deg");
   y -= step;
   l.DrawMathText(x1, y, "\\det");
   l.DrawText(x2, y, "\\det");
   y -= step;
   l.DrawMathText(x1, y, "\\dim");
   l.DrawText(x2, y, "\\dim");
   y -= step;
   l.DrawMathText(x1, y, "\\exp");
   l.DrawText(x2, y, "\\exp");
   y -= step;
   l.DrawMathText(x1, y, "\\gcd");
   l.DrawText(x2, y, "\\gcd");
   y -= step;
   l.DrawMathText(x1, y, "\\hom");
   l.DrawText(x2, y, "\\hom");
   y -= step;
   l.DrawMathText(x1, y, "\\inf");
   l.DrawText(x2, y, "\\inf");
   y -= step;
   l.DrawMathText(x1, y, "\\ker");
   l.DrawText(x2, y, "\\ker");
   y -= step;
   l.DrawMathText(x1, y, "\\lg");
   l.DrawText(x2, y, "\\lg");
   y -= step;
   l.DrawMathText(x1, y, "\\lim");
   l.DrawText(x2, y, "\\lim");
   y -= step;
   l.DrawMathText(x1, y, "\\liminf");
   l.DrawText(x2, y, "\\liminf");
   y -= step;
   l.DrawMathText(x1, y, "\\limsup");
   l.DrawText(x2, y, "\\limsup");
   y -= step;
   l.DrawMathText(x1, y, "\\ln");
   l.DrawText(x2, y, "\\ln");
   y -= step;
   l.DrawMathText(x1, y, "\\log");
   l.DrawText(x2, y, "\\log");
   y -= step;
   l.DrawMathText(x1, y, "\\max");
   l.DrawText(x2, y, "\\max");
   y -= step;
   l.DrawMathText(x1, y, "\\min");
   l.DrawText(x2, y, "\\min");
   y -= step;
   l.DrawMathText(x1, y, "\\sec");
   l.DrawText(x2, y, "\\sec");
   y -= step;
   l.DrawMathText(x1, y, "\\sin");
   l.DrawText(x2, y, "\\sin");
   y -= step;
   l.DrawMathText(x1, y, "\\sinh");
   l.DrawText(x2, y, "\\sinh");
   y -= step;
   l.DrawMathText(x1, y, "\\sup");
   l.DrawText(x2, y, "\\sup");
   y -= step;
   l.DrawMathText(x1, y, "\\tan");
   l.DrawText(x2, y, "\\tan");
   y -= step;
   l.DrawMathText(x1, y, "\\tanh");
   l.DrawText(x2, y, "\\tanh");

   return c1;
}
