# Node.js

Trivy supports four types of Node.js package managers: `npm`, `Yarn`, `pnpm` and `Bun`[^1].

The following scanners are supported.

| Artifact | SBOM | Vulnerability | License |
|----------|:----:|:-------------:|:-------:|
| npm      |  ✓   |       ✓       |    ✓    |
| Yarn     |  ✓   |       ✓       |    ✓    |
| pnpm     |  ✓   |       ✓       |    ✓    |
| Bun      |  ✓   |       ✓       |    ✓    |

The following table provides an outline of the features Trivy offers.

| Package manager | File              | Transitive dependencies |         Dev dependencies          | [Dependency graph][dependency-graph] | Position |
|:---------------:|-------------------|:-----------------------:|:---------------------------------:|:------------------------------------:|:--------:|
|       npm       | package-lock.json |            ✓            |         [Excluded](#npm)          |                  ✓                   |    ✓     |
|      Yarn       | yarn.lock         |            ✓            |         [Excluded](#yarn)         |                  ✓                   |    ✓     |
|      pnpm       | pnpm-lock.yaml    |            ✓            | [Excluded](#lock-file-v9-version) |                  ✓                   |    -     |
|       Bun       | bun.lock          |            ✓            |         [Excluded](#bun)          |                  ✓                   |    ✓     |

In addition, Trivy scans installed packages with `package.json`.

| File         | Dependency graph | Position | License |
|--------------|:----------------:|:--------:|:-------:|
| package.json |        -         |    -     |    ✅    |

These may be enabled or disabled depending on the target.
See [here](./index.md) for the detail.

## Package managers
Trivy parses your files generated by package managers in filesystem/repository scanning.

!!! tip
    Please make sure your lock file is up-to-date after modifying `package.json`.

### npm
Trivy parses `package-lock.json`.
To identify licenses, you need to download dependencies to `node_modules` beforehand.
Trivy analyzes `node_modules` for licenses.

By default, Trivy doesn't report development dependencies. Use the `--include-dev-deps` flag to include them.

### Yarn
Trivy parses `yarn.lock`.

Trivy also analyzes additional files to gather more information about the detected dependencies.

- package.json
- node_modules/**

#### Package relationships
`yarn.lock` files don't contain information about package relationships, such as direct or indirect dependencies.
To enrich this information, Trivy parses the `package.json` file located next to the `yarn.lock` file as well as workspace `package.json` files.

By default, Trivy doesn't report development dependencies.
Use the `--include-dev-deps` flag to include them in the results.

#### Development dependencies
`yarn.lock` files don't contain information about package groups, such as production and development dependencies.
To identify dev dependencies and support [aliases][yarn-aliases], Trivy parses the `package.json` file located next to the `yarn.lock` file as well as workspace `package.json` files.

#### Licenses
Trivy analyzes the `.yarn` directory (for Yarn 2+) or the `node_modules` directory (for Yarn Classic) located next to the `yarn.lock` file to detect licenses.

### pnpm
Trivy parses `pnpm-lock.yaml`, then finds production dependencies and builds a [tree][dependency-graph] of dependencies with vulnerabilities.
To identify licenses, you need to download dependencies to `node_modules` beforehand. Trivy analyzes `node_modules` for licenses.

#### lock file v9 version
Trivy supports `Dev` field for `pnpm-lock.yaml` v9 or later. Use the `--include-dev-deps` flag to include the developer's dependencies in the result.

### Bun
Trivy also supports scanning `bun.lock` file generated by [Bun](https://bun.sh/blog/bun-lock-text-lockfile). 
You can use Bun v1.2 which uses this file as default or use `bun install --save-text-lockfile` in Bun v1.1.39 to generate it.

For previous Bun versions you can use the command `bun install -y` to generate a Yarn-compatible `yarn.lock` and then scan it with Trivy.

#### Development dependencies
`bun.lock` contains information about package groups, such as production and development dependencies. By default, Trivy doesn't report development dependencies. Use the `--include-dev-deps` flag to include them.

!!! note
    `bun.lockb` is not supported.

## Packages
Trivy parses the manifest files of installed packages in container image scanning and so on.

### package.json
Trivy searches for `package.json` files under `node_modules` and identifies installed packages.
It only extracts package names, versions and licenses for those packages.

[dependency-graph]: ../../configuration/reporting.md#show-origins-of-vulnerable-dependencies
[pnpm-lockfile-v6]: https://github.com/pnpm/spec/blob/fd3238639af86c09b7032cc942bab3438b497036/lockfile/6.0.md
[yarn-aliases]: https://classic.yarnpkg.com/lang/en/docs/cli/add/#toc-yarn-add-alias

[^1]: [yarn.lock](#bun) must be generated
