/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.coredump;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.coredump.CoreDumpsContainer;
import org.graalvm.visualvm.coredump.CoreDumpsContainerDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.actions.Presenter;

final class CoreDumpsSorting
implements Presenter.Menu {
    private static final String PROP_HOSTS_SORTING = "CoreDumps.sorting";
    private static CoreDumpsSorting instance;
    private static final Comparator<DataSource> BY_TIME_COMPARATOR;
    private static final Comparator<DataSource> BY_NAME_COMPARATOR;
    private static final List<Comparator<DataSource>> COMPARATORS;
    private final Preferences prefs = NbPreferences.forModule(CoreDumpsSorting.class);
    private JMenuItem presenter;
    private final Sorter sorter = new Sorter(){

        @Override
        public void sort(Comparator<DataSource> comparator) {
            DataSourceDescriptor d = DataSourceDescriptorFactory.getDescriptor((DataSource)CoreDumpsContainer.sharedInstance());
            if (d instanceof CoreDumpsContainerDescriptor) {
                ((CoreDumpsContainerDescriptor)d).setChildrenComparator(comparator);
                CoreDumpsSorting.this.prefs.putInt(CoreDumpsSorting.PROP_HOSTS_SORTING, COMPARATORS.indexOf(comparator));
            }
        }
    };

    public static synchronized CoreDumpsSorting instance() {
        if (instance == null) {
            instance = new CoreDumpsSorting();
        }
        return instance;
    }

    public JMenuItem getMenuPresenter() {
        if (this.presenter == null) {
            this.presenter = this.createPresenter();
        }
        return this.presenter;
    }

    Comparator<DataSource> getInitialSorting() {
        return COMPARATORS.get(this.prefs.getInt(PROP_HOSTS_SORTING, COMPARATORS.indexOf(BY_TIME_COMPARATOR)));
    }

    private JMenuItem createPresenter() {
        JMenu menu = new JMenu(){

            @Override
            protected void fireMenuSelected() {
                Component[] items;
                for (Component item : items = this.getMenuComponents()) {
                    if (!(item instanceof SortAction)) continue;
                    ((SortAction)item).updateAction();
                }
            }
        };
        Mnemonics.setLocalizedText((AbstractButton)menu, (String)NbBundle.getMessage(CoreDumpsSorting.class, (String)"ACT_SortCoreDumps"));
        menu.add(new SortAction(NbBundle.getMessage(CoreDumpsSorting.class, (String)"ACT_TimeAdded"), BY_TIME_COMPARATOR, this.sorter));
        menu.add(new SortAction(NbBundle.getMessage(CoreDumpsSorting.class, (String)"ACT_DisplayName"), BY_NAME_COMPARATOR, this.sorter));
        return menu;
    }

    private static Comparator<DataSource> byTimeComparator() {
        return null;
    }

    private static Comparator<DataSource> byNameComparator() {
        return new Comparator<DataSource>(){

            @Override
            public int compare(DataSource d1, DataSource d2) {
                DataSourceDescriptor dd1 = DataSourceDescriptorFactory.getDescriptor((DataSource)d1);
                DataSourceDescriptor dd2 = DataSourceDescriptorFactory.getDescriptor((DataSource)d2);
                return dd1.getName().compareTo(dd2.getName());
            }
        };
    }

    private CoreDumpsSorting() {
    }

    static {
        BY_TIME_COMPARATOR = CoreDumpsSorting.byTimeComparator();
        BY_NAME_COMPARATOR = CoreDumpsSorting.byNameComparator();
        COMPARATORS = new ArrayList<Comparator<DataSource>>();
        COMPARATORS.add(BY_TIME_COMPARATOR);
        COMPARATORS.add(BY_NAME_COMPARATOR);
    }

    private static interface Sorter {
        public void sort(Comparator<DataSource> var1);
    }

    private static class SortAction
    extends JRadioButtonMenuItem {
        private final Sorter sorter;
        private final Comparator<DataSource> comparator;
        private boolean currentlySelected;

        SortAction(String name, Comparator<DataSource> comparator, Sorter sorter) {
            Mnemonics.setLocalizedText((AbstractButton)this, (String)name);
            this.comparator = comparator;
            this.sorter = sorter;
        }

        void updateAction() {
            DataSourceDescriptor d = DataSourceDescriptorFactory.getDescriptor((DataSource)CoreDumpsContainer.sharedInstance());
            this.setEnabled(d instanceof CoreDumpsContainerDescriptor);
            this.currentlySelected = d.getChildrenComparator() == this.comparator;
            this.setSelected(this.currentlySelected);
        }

        @Override
        protected void fireActionPerformed(ActionEvent e) {
            if (!this.currentlySelected) {
                this.sorter.sort(this.comparator);
            }
        }
    }
}

